/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.network;

import java.util.HashMap;
import java.util.Map;
import net.Gabou.projectatmosphere.client.BiomeClientTemperatureCache;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record BiomeDayTemperaturePacket(Map<ResourceLocation, float[]> temperatureDayMap) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"biomedaytemperaturepacket");
    public static final CustomPacketPayload.Type<BiomeDayTemperaturePacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, BiomeDayTemperaturePacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeVarInt(pkt.temperatureDayMap.size());
        pkt.temperatureDayMap.forEach((biome, temps) -> {
            buf.writeResourceLocation(biome);
            buf.writeVarInt(((float[])temps).length);
            for (float f : temps) {
                buf.writeFloat(f);
            }
        });
    }, buf -> {
        int size = buf.readVarInt();
        HashMap<ResourceLocation, float[]> map = new HashMap<ResourceLocation, float[]>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation biome = buf.readResourceLocation();
            int len = buf.readVarInt();
            float[] temps = new float[len];
            for (int j = 0; j < len; ++j) {
                temps[j] = buf.readFloat();
            }
            map.put(biome, temps);
        }
        return new BiomeDayTemperaturePacket(map);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(BiomeDayTemperaturePacket pkt, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BiomeClientTemperatureCache.clear();
            BiomeClientTemperatureCache.updateDayForecasts(pkt.temperatureDayMap());
        });
    }
}

