/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import java.util.Locale;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;

public final class UnitFormatter {
    private UnitFormatter() {
    }

    public static boolean imperial() {
        return (Boolean)AtmoCommonConfig.DISPLAY_UNITS_IMPERIAL.get();
    }

    public static String formatTemperature(float celsius) {
        if (UnitFormatter.imperial()) {
            float f = celsius * 9.0f / 5.0f + 32.0f;
            return String.format(Locale.US, "%.1f\u00b0F", Float.valueOf(f));
        }
        return String.format(Locale.US, "%.1f\u00b0C", Float.valueOf(celsius));
    }

    public static String formatWindSpeed(float metersPerSecond) {
        if (UnitFormatter.imperial()) {
            float mph = metersPerSecond * 2.2369363f;
            return String.format(Locale.US, "%.1f mph", Float.valueOf(mph));
        }
        return String.format(Locale.US, "%.1f m/s", Float.valueOf(metersPerSecond));
    }

    public static String formatPressure(double hPa) {
        if (UnitFormatter.imperial()) {
            double inHg = hPa * 0.0295299830714;
            return String.format(Locale.US, "%.2f inHg", inHg);
        }
        return String.format(Locale.US, "%.1f hPa", hPa);
    }

    public static String formatHumidity(float percent) {
        return String.format(Locale.US, "%.1f%%", Float.valueOf(percent));
    }
}

