/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.manager.SimpleCloudSpawner;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.snowstorm.SnowstormManager;
import net.Gabou.projectatmosphere.modules.temperature.command.TemperatureCommandHelper;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.UnitFormatter;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class DebugAtmoCommand {
    public static final Logger LOGGER = LogManager.getLogger((String)"DebugAtmoCommand");

    private static int sendForecast(CommandContext<CommandSourceStack> ctx, BiomeForecast forecast, ResourceLocation biome) {
        if (forecast == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("No forecast found for biome: " + String.valueOf(biome))));
            return 0;
        }
        String temps = DebugAtmoCommand.formatTemps(forecast.getTemperatureDay());
        String pressures = DebugAtmoCommand.formatPressures(forecast.getPressureDay());
        String humidities = DebugAtmoCommand.formatHumidities(forecast.getHumidityDay());
        WindVector w = forecast.getWindDay();
        String wind = w == null ? "-" : UnitFormatter.formatWindSpeed(w.baseSpeed()) + " at " + String.format("%.0f\u00b0", Math.toDegrees(w.angleRadians()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Biome: " + String.valueOf(biome) + "\n  Temp:     [" + temps + "]\n  Pressure: [" + pressures + "]\n  Humidity: [" + humidities + "]\n  Wind:     [" + wind + "]")), false);
        return 1;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"weatherdebug").then(((LiteralArgumentBuilder)Commands.literal((String)"forecast").executes(ctx -> {
            ServerLevel world = ((CommandSourceStack)ctx.getSource()).getLevel();
            if (!TemperatureCommandHelper.isInOverworld((Level)world)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Weather forecast is only available in the Overworld."));
                return 0;
            }
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition());
            ResourceLocation biome = world.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)world.getBiome(pos).value()));
            BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(new BiomeInstanceKey(biome, pos), ForecastType.WIND);
            return DebugAtmoCommand.sendForecast((CommandContext<CommandSourceStack>)ctx, forecast, biome);
        })).then(Commands.argument((String)"biome", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> {
            if (!TemperatureCommandHelper.isInOverworld((Level)((CommandSourceStack)ctx.getSource()).getLevel())) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Biome forecast is only available in the Overworld."));
                return 0;
            }
            ResourceLocation biome = ResourceLocationArgument.getId((CommandContext)ctx, (String)"biome");
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition());
            BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(new BiomeInstanceKey(biome, pos), ForecastType.WIND);
            return DebugAtmoCommand.sendForecast((CommandContext<CommandSourceStack>)ctx, forecast, biome);
        })))).then(Commands.literal((String)"cpu").executes(ctx -> {
            int cores = Runtime.getRuntime().availableProcessors();
            boolean forceShared = false;
            String mode = forceShared || cores <= 6 ? "Shared Executor (1 thread pool)" : (cores <= 10 ? "Two Executor Groups (shared in pairs)" : "Four Separate Executors");
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("CPU Info\n- Logical cores: " + cores + "\n- Force shared (config): " + forceShared + "\n- Current async mode: " + mode)), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"rain").executes(DebugAtmoCommand::spawnRain)).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(DebugAtmoCommand::spawnRain)).then(((RequiredArgumentBuilder)Commands.argument((String)"noThunder", (ArgumentType)BoolArgumentType.bool()).executes(DebugAtmoCommand::spawnRain)).then(Commands.argument((String)"intensity", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2)).executes(DebugAtmoCommand::spawnRain)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"thunder").executes(DebugAtmoCommand::spawnThunder)).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(DebugAtmoCommand::spawnThunder)).then(Commands.argument((String)"intensity", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2)).executes(DebugAtmoCommand::spawnThunder))))).then(((LiteralArgumentBuilder)Commands.literal((String)"snowstorm").executes(DebugAtmoCommand::spawnSnowstorm)).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(DebugAtmoCommand::spawnSnowstorm)).then(Commands.argument((String)"overwrite", (ArgumentType)BoolArgumentType.bool()).executes(DebugAtmoCommand::spawnSnowstorm))))).then(Commands.argument((String)"violence", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> {
            int violence = SimpleCloudSpawner.getCurrentViolence();
            if (violence == 0) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"No violence detected"));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Violence is: " + violence + "\nCloudViolence: [" + violence + "]")), false);
            return 1;
        })));
    }

    private static CloudRegion spawnCloud(ServerLevel level, BlockPos pos, String cloudId) {
        if (SimpleCloudsCompat.generator == null) {
            LOGGER.warn("Simple Clouds generator is null, cannot spawn cloud.");
            return null;
        }
        if (cloudId == null) {
            LOGGER.warn("Cloud ID is null, cannot spawn cloud.");
            return null;
        }
        if (!level.dimension().equals(Level.OVERWORLD)) {
            return null;
        }
        CloudGenerator generator = SimpleCloudsCompat.generator;
        CloudRegion existing = generator.getCloudAtWorldPosition((float)pos.getX(), (float)pos.getZ());
        if (existing != null) {
            generator.removeClouds(r -> r == existing);
        }
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, (Level)level), pos);
        WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.getGameTime());
        return SimpleCloudsCompat.spawnCloudInBiome(cloudId, key, level, null, wind);
    }

    private static int spawnRain(CommandContext<CommandSourceStack> ctx) {
        int intensity;
        boolean noThunder;
        BlockPos pos;
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        if (!TemperatureCommandHelper.isInOverworld((Level)level)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Rain clouds can only be spawned in the Overworld."));
            return 0;
        }
        try {
            pos = BlockPosArgument.getBlockPos(ctx, (String)"pos");
        }
        catch (IllegalArgumentException e) {
            pos = BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition());
        }
        try {
            noThunder = BoolArgumentType.getBool(ctx, (String)"noThunder");
        }
        catch (IllegalArgumentException e) {
            noThunder = false;
        }
        try {
            intensity = IntegerArgumentType.getInteger(ctx, (String)"intensity");
        }
        catch (IllegalArgumentException e) {
            intensity = 1;
        }
        String cloudId = CloudLibrary.getRandomRainCloud(intensity, !noThunder);
        DebugAtmoCommand.spawnCloud(level, pos, cloudId);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Spawned rain cloud: " + cloudId)), true);
        return 1;
    }

    private static int spawnThunder(CommandContext<CommandSourceStack> ctx) {
        int intensity;
        BlockPos pos;
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        if (!TemperatureCommandHelper.isInOverworld((Level)level)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Thunder clouds can only be spawned in the Overworld."));
            return 0;
        }
        try {
            pos = BlockPosArgument.getBlockPos(ctx, (String)"pos");
        }
        catch (IllegalArgumentException e) {
            pos = BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition());
        }
        try {
            intensity = IntegerArgumentType.getInteger(ctx, (String)"intensity");
        }
        catch (IllegalArgumentException e) {
            intensity = 1;
        }
        String cloudId = CloudLibrary.getRandomThunderCloud(intensity);
        DebugAtmoCommand.spawnCloud(level, pos, cloudId);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Spawned thunder cloud: " + cloudId)), true);
        return 1;
    }

    private static int spawnSnowstorm(CommandContext<CommandSourceStack> ctx) {
        boolean overwrite;
        int intensity;
        BlockPos pos;
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        if (!TemperatureCommandHelper.isInOverworld((Level)level)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Snowstorm clouds can only be spawned in the Overworld."));
            return 0;
        }
        try {
            pos = BlockPosArgument.getBlockPos(ctx, (String)"pos");
        }
        catch (IllegalArgumentException e) {
            pos = BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition());
        }
        try {
            intensity = IntegerArgumentType.getInteger(ctx, (String)"intensity");
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"No intensity given."));
            return 0;
        }
        try {
            overwrite = BoolArgumentType.getBool(ctx, (String)"overwrite");
        }
        catch (IllegalArgumentException e) {
            overwrite = false;
        }
        if (SeasonHelper.getSeasonState((Level)level).getSeason() != Season.WINTER) {
            if (!overwrite) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"It is not winter."));
                return 0;
            }
            try {
                ISeasonState state = SeasonHelper.getSeasonState((Level)level);
                state.getClass().getMethod("setSeason", Season.class).invoke((Object)state, Season.WINTER);
            }
            catch (Exception e) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to overwrite season."));
                return 0;
            }
        }
        String cloudId = CloudLibrary.getSnowstormCloudId();
        CloudRegion region = DebugAtmoCommand.spawnCloud(level, pos, cloudId);
        SnowstormManager.startSnowstorm(intensity, region);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Spawned snowstorm cloud."), true);
        return 1;
    }

    private static String formatTemps(float[] arr) {
        if (arr == null || arr.length == 0) {
            return "-";
        }
        if (arr.length == 1) {
            return UnitFormatter.formatTemperature(arr[0]);
        }
        return UnitFormatter.formatTemperature(arr[0]) + ", " + UnitFormatter.formatTemperature(arr[1]);
    }

    private static String formatPressures(float[] arr) {
        if (arr == null || arr.length == 0) {
            return "-";
        }
        if (arr.length == 1) {
            return UnitFormatter.formatPressure(arr[0]);
        }
        return UnitFormatter.formatPressure(arr[0]) + ", " + UnitFormatter.formatPressure(arr[1]);
    }

    private static String formatHumidities(float[] arr) {
        if (arr == null || arr.length == 0) {
            return "-";
        }
        if (arr.length == 1) {
            return UnitFormatter.formatHumidity(arr[0]);
        }
        return UnitFormatter.formatHumidity(arr[0]) + ", " + UnitFormatter.formatHumidity(arr[1]);
    }
}

