/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.compat;

import java.util.concurrent.CompletableFuture;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.async.ThreadingDetector;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.temperature.TemperatureHelperImpl;

public class ToughAsNailsCompat {
    private static final float DAILY_JITTER = 0.5f;
    private static final float DAILY_SWING = 4.0f;

    public static float[][] injectForecastForTAN(BiomeInstanceKey key, ServerLevel level) {
        BlockPos sample = key.samplePos();
        RandomSource rng = RandomSource.create((long)(sample.asLong() ^ level.getSeed()));
        if (ThreadingDetector.isMainThread(level)) {
            TemperatureLevel band = TemperatureHelperImpl.getTemperatureAtPosWithoutProximity((Level)level, (BlockPos)sample);
            float baseTemp = ToughAsNailsCompat.mapBandToTemperature(band);
            return ToughAsNailsCompat.generateMinMaxCurve(baseTemp, rng);
        }
        CompletableFuture future = new CompletableFuture();
        AsyncAtmosphereService.runOnMainThread(() -> {
            try {
                TemperatureLevel band = TemperatureHelperImpl.getTemperatureAtPosWithoutProximity((Level)level, (BlockPos)sample);
                float baseTemp = ToughAsNailsCompat.mapBandToTemperature(band);
                future.complete(Float.valueOf(baseTemp));
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        try {
            float baseTemp = ((Float)future.join()).floatValue();
            return ToughAsNailsCompat.generateMinMaxCurve(baseTemp, rng);
        }
        catch (Exception e) {
            ProjectAtmosphere.LOGGER.error("[TAN Compat] Failed to generate forecast", (Throwable)e);
            return new float[7][2];
        }
    }

    private static float[][] generateMinMaxCurve(float base, RandomSource random) {
        float[][] result = new float[7][2];
        for (int i = 0; i < 7; ++i) {
            float swing = 4.0f * (float)Math.sin((double)((float)i / 6.0f) * Math.PI);
            float min = (float)((double)(base - swing / 2.0f) + random.nextGaussian() * 0.5);
            float max = (float)((double)(base + swing / 2.0f) + random.nextGaussian() * 0.5);
            result[i][0] = (float)Math.round(min * 10.0f) / 10.0f;
            result[i][1] = (float)Math.round(max * 10.0f) / 10.0f;
        }
        return result;
    }

    private static float mapBandToTemperature(TemperatureLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case TemperatureLevel.ICY -> -20.0f;
            case TemperatureLevel.COLD -> 0.0f;
            case TemperatureLevel.NEUTRAL -> 15.0f;
            case TemperatureLevel.WARM -> 28.0f;
            case TemperatureLevel.HOT -> 38.0f;
        };
    }

    public static boolean isLoaded() {
        return CompatHandler.isToughAsNailsLoaded();
    }

    public static float getLiveTemperatureTAN(Level level, BlockPos pos) {
        TemperatureLevel band = TemperatureHelperImpl.getTemperatureAtPosWithoutProximity((Level)level, (BlockPos)pos);
        return ToughAsNailsCompat.mapBandToTemperature(band);
    }
}

