/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.manager.ForecastDataStorage;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeChangeManager {
    private static final Map<UUID, Pair<ResourceLocation, Boolean>> lastBiome = new HashMap<UUID, Pair<ResourceLocation, Boolean>>();
    private static final int RUN_INTERVAL_TICKS = 2000;
    private static final int MIN_DISTANCE_BETWEEN_CENTERS = 6000;
    private static final boolean sandStormsLoaded = CompatHandler.isSandStormsLoaded();
    private static final Set<String> SANDSTORM_KEYWORDS = Set.of("desert", "badlands", "mesa", "wasteland", "volcanic_plains", "lush_desert", "cold_desert", "dryland", "scrubland", "shrubland", "rocky_shrubland", "tundra", "dead_forest", "old_growth_dead_forest", "arid", "savanna_badlands", "red_desert", "ash", "barren", "dry");

    public static Map<UUID, Pair<ResourceLocation, Boolean>> getLastBiome() {
        return lastBiome;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post ev) {
        ResourceLocation last;
        Player player = ev.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.level().isClientSide) {
            return;
        }
        ServerLevel level = player2.serverLevel();
        long t = player2.serverLevel().getDayTime() % 24000L;
        if (t % 2000L != 0L) {
            return;
        }
        UUID uuid = player2.getUUID();
        ResourceLocation nowBiome = BiomeChangeManager.getBiomeKeyAt(player2);
        try {
            last = (ResourceLocation)lastBiome.get(uuid).getKey();
            boolean wasInDesert = (Boolean)lastBiome.get(uuid).getValue();
        }
        catch (NullPointerException e) {
            last = null;
            boolean wasInDesert = false;
        }
        if (last == null || !last.equals((Object)nowBiome)) {
            lastBiome.put(uuid, (Pair<ResourceLocation, Boolean>)Pair.of((Object)nowBiome, (Object)BiomeChangeManager.isDesert(nowBiome)));
            BiomeChangeManager.onBiomeChanged(player2, last, nowBiome);
        }
    }

    public static boolean isDesert(ResourceLocation biomeId) {
        return BiomeChangeManager.isSandstormBiome(biomeId);
    }

    private static boolean isSandstormBiome(ResourceLocation biomeKey) {
        if (biomeKey == null) {
            return false;
        }
        String path = biomeKey.getPath().toLowerCase();
        for (String keyword : SANDSTORM_KEYWORDS) {
            if (!path.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private static ResourceLocation getBiomeKeyAt(ServerPlayer p) {
        BlockPos pos = p.blockPosition();
        return p.serverLevel().getBiome(pos).unwrapKey().map(ResourceKey::location).orElse(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains"));
    }

    private static void onBiomeChanged(ServerPlayer player, ResourceLocation oldBiome, ResourceLocation newBiome) {
        UUID uuid = player.getUUID();
        BlockPos currentPos = player.blockPosition();
        BlockPos originalCenter = ForecastDataStorage.playerData.get(uuid);
        ForecastOrchestrator.clearActiveBiomeKeysForPlayer(player);
        ForecastOrchestrator.getNearbyBiomeKeys(player.serverLevel(), player, 500.0);
        if (originalCenter == null || originalCenter.distManhattan((Vec3i)currentPos) > 6000) {
            ForecastDataStorage.playerData.put(uuid, currentPos);
            AtmosphereManager.updateForecastAround(player.serverLevel(), currentPos);
            player.sendSystemMessage((Component)Component.literal((String)"[Atmosphere] Moved >5000 blocks. Forecast regenerated."));
        }
    }
}

