/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.hurricane;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneCategory;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneInstance;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneManager;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModTags;

public class HurricaneCommand {
    public static void register(RegisterCommandsEvent event) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawnHurricane").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"category", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = player.serverLevel();
            if (!level.dimension().equals(Level.OVERWORLD)) {
                return 0;
            }
            BlockPos pos = player.blockPosition();
            Holder biome = level.getBiome(pos);
            if (!biome.is(BiomeTags.IS_OCEAN) && !biome.is(ModTags.Biomes.TROPICAL_BIOMES)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Hurricanes can only spawn in warm oceans."));
                return 0;
            }
            Season.SubSeason sub = SeasonHelper.getSeasonState((Level)level).getSubSeason();
            if (sub.ordinal() < Season.SubSeason.LATE_SPRING.ordinal() || sub.ordinal() > Season.SubSeason.EARLY_AUTUMN.ordinal()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Hurricanes only spawn between late spring and early fall."));
                return 0;
            }
            int catInt = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"category");
            HurricaneCategory cat = HurricaneCategory.fromId(catInt);
            BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, (Level)level), pos);
            WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.getGameTime());
            SimpleCloudsCompat.spawnCloudInBiome("custom_cumulonimbus", key, level, null, wind);
            Vec3 spawnPos = new Vec3(player.getX(), (double)level.getSeaLevel(), player.getZ());
            HurricaneManager.spawnServer(level, spawnPos, 40.0f, wind, cat);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\ud83c\udf00 Hurricane category " + catInt + " spawned.")), true);
            return 1;
        }));
        event.getDispatcher().register(base);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clearhurricanes").requires(source -> source.hasPermission(2))).executes(ctx -> {
            HurricaneManager.clearHurricanes();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\ud83c\udf00 All hurricanes cleared."), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removehurricane").requires(source -> source.hasPermission(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Vec3 playerPos = player.position();
            HurricaneInstance hurricane = HurricaneManager.getActiveHurricanes().stream().filter(h -> h.position.distanceToSqr(playerPos) < 400.0).findFirst().orElse(null);
            if (hurricane != null) {
                HurricaneManager.removeHurricane(hurricane);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\ud83c\udf00 Hurricane removed."), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"No hurricane found near you."));
            }
            return 1;
        }));
    }
}

