/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Arrays;
import java.util.Set;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.modules.temperature.command.TemperatureCommandHelper;
import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeManager;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.UnitFormatter;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class TemperatureCommands {
    public static final SuggestionProvider<CommandSourceStack> BIOME_SUGGESTIONS = (ctx, builder) -> {
        Set biomeIds = ((CommandSourceStack)ctx.getSource()).getServer().registryAccess().registryOrThrow(Registries.BIOME).keySet();
        biomeIds.forEach(id -> builder.suggest(id.toString()));
        builder.suggest("current");
        builder.suggest("currentbiome");
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"temperature").then(Commands.literal((String)"forecast").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (!TemperatureCommandHelper.isInOverworld(player.level())) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Temperature forecast is only available in the Overworld."));
                return 0;
            }
            String forecast = TemperatureCommandHelper.getWeeklyForecast(TemperatureCommandHelper.getCurrentBiomeResourceLocation((Player)player));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)forecast), false);
            return 1;
        }))).then(Commands.literal((String)"get").then(Commands.argument((String)"biome", (ArgumentType)StringArgumentType.word()).suggests(BIOME_SUGGESTIONS).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (!TemperatureCommandHelper.isInOverworld(player.level())) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Temperature forecast is only available in the Overworld."));
                return 0;
            }
            String biomeStr = StringArgumentType.getString((CommandContext)ctx, (String)"biome");
            BiomeInstanceKey biome = TemperatureCommandHelper.resolveBiome((Player)player, biomeStr);
            long tick = TemperatureCommandHelper.getCurrentTick(((CommandSourceStack)ctx.getSource()).getLevel());
            float temp = TemperatureCommandHelper.getTemperatureAt(biome, tick);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(String.valueOf(biome.biomeType()) + " @ tick " + tick + ": " + UnitFormatter.formatTemperature(temp))), false);
            return 1;
        })))).then(Commands.literal((String)"dayprofile").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (!TemperatureCommandHelper.isInOverworld(player.level())) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Temperature forecast is only available in the Overworld."));
                return 0;
            }
            BiomeInstanceKey biome = TemperatureCommandHelper.getCurrentBiome((Player)player);
            float[] profile = TemperatureCommandHelper.getDayProfile(biome);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Day profile: " + Arrays.toString(profile))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"getseason").requires(source -> source.hasPermission(2))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
            String subSeason = TemperatureCommandHelper.getCurrentSubSeason(level);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Current season: " + subSeason)), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"gettemp").requires(source -> source.hasPermission(2))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (!TemperatureCommandHelper.isInOverworld(player.level())) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Temperature forecast is only available in the Overworld."));
                return 0;
            }
            BlockPos pos = player.getOnPos();
            Holder biomeHolder = level.getBiome(pos);
            BiomeInstanceKey biomeId = new BiomeInstanceKey(((ResourceKey)biomeHolder.unwrapKey().get()).location(), pos);
            float serene = TemperatureCommandHelper.getFinalBiomeTemperature((Level)level, (Holder<Biome>)biomeHolder, pos);
            double celsius = TemperatureCommandHelper.convertToCelsius(serene);
            float realTemp = TemperatureCommandHelper.getRealTemperature(level, biomeId, pos);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Current temperature (raw): " + serene)), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Converted: " + UnitFormatter.formatTemperature((float)celsius))), false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Current (converted): " + UnitFormatter.formatTemperature(realTemp))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"regenerate").requires(source -> source.hasPermission(2))).executes(ctx -> {
            ServerLevel level;
            if (((CommandSourceStack)ctx.getSource()).getPlayer() == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"This command can only be run by a player."));
            }
            if (!TemperatureCommandHelper.isInOverworld((Level)(level = ((CommandSourceStack)ctx.getSource()).getLevel()))) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Temperature forecast is only available in the Overworld."));
                return 0;
            }
            AtmosphereManager.onRegenerate(level);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Temperature forecast cache has been cleared."), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"resetSpikes").requires(source -> source.hasPermission(2))).executes(ctx -> {
            SpikeManager.clearSpikeCache(((CommandSourceStack)ctx.getSource()).getLevel());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Spike's cache has been cleared."), false);
            return 1;
        }))).then(Commands.literal((String)"help").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"[Temperature Commands Help]\n/temperature forecast - Show 7-day forecast for your current biome.\n/temperature get <biome|current> - Display the current temperature at a specific biome and tick.\n/temperature dayprofile - View the 240-point daily temperature curve.\n/temperature getseason - Show the current Serene Seasons sub-season.\n/temperature gettemp - Raw and converted temperatures.\n/temperature regenerate - Clear forecast cache and regenerate missing data.\n/temperature resetSpikes - Clear spike simulation state cache."), false);
            return 1;
        })));
    }
}

