/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.DelayedTaskScheduler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class TornadoCommand {
    public static void register(RegisterCommandsEvent event) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawnTornado").requires(source -> source.hasPermission(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = player.serverLevel();
            if (!level.dimension().equals(Level.OVERWORLD)) {
                return 0;
            }
            BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(player.blockPosition(), (Level)level), player.blockPosition());
            WindVectorApi.WindSample sample = WindVectorApi.getOrFallback(key);
            WindVector wind = WindVector.fromBase(sample.speedMps(), (float)Math.toRadians(sample.directionDeg()));
            SimpleCloudsCompat.spawnCloudInBiome("cumulonimbus", key, level, null, wind);
            Vec3 playerPos = player.position();
            if (CloudManager.get((Level)level).getClouds().stream().noneMatch(cloudRegion -> cloudRegion.intersects(new SpawnRegion(player.getBlockX(), player.getBlockZ(), 10)) && cloudRegion.getCloudTypeId().toString().equals("simpleclouds:cumulonimbus"))) {
                SimpleCloudsCompat.spawnCloudInBiome("cumulonimbus", key, level, null, wind);
                DelayedTaskScheduler.schedule(500, () -> TornadoManager.spawnServer(level, new Vec3(playerPos.x, (double)level.getSeaLevel(), playerPos.z), 10.0f, wind));
            } else {
                TornadoManager.spawnServer(level, new Vec3(playerPos.x, (double)level.getSeaLevel(), playerPos.z), 10.0f, wind);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\ud83c\udf2a\ufe0f Tornado + \u2601\ufe0f Cumulonimbus spawned. in 500 ticks"), true);
            return 1;
        });
        event.getDispatcher().register(baseCommand);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawntornadoes").requires(src -> src.hasPermission(2))).executes(baseCommand.getCommand()));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cleartornadoes").requires(src -> src.hasPermission(2))).executes(ctx -> {
            TornadoManager.clearTornadoes();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\ud83c\udf2a\ufe0f All tornadoes cleared."), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removetornado").requires(src -> src.hasPermission(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = player.serverLevel();
            if (!level.dimension().equals(Level.OVERWORLD)) {
                return 0;
            }
            Vec3 playerPos = player.position();
            TornadoInstance tornado = TornadoManager.getActiveTornadoes().stream().filter(t -> t.position.distanceToSqr(playerPos) < 100.0).findFirst().orElse(null);
            if (tornado != null) {
                TornadoManager.removeTornado(tornado);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\ud83c\udf2a\ufe0f Tornado removed."), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"No tornado found near you."));
            }
            return 1;
        }));
    }
}

