/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.particles;

import java.lang.ref.WeakReference;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.particles.DebrisParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class DebrisParticle
extends TextureSheetParticle {
    private final WeakReference<TornadoInstance> tornadoRef;
    private final double radius;
    private final double baseY;
    private final float angularSpeed;
    private final float startAngle;

    protected DebrisParticle(ClientLevel level, TornadoInstance tornado, double radius, double height, float angularSpeed) {
        super(level, tornado.position.x, tornado.position.y + height, tornado.position.z, 0.0, 0.0, 0.0);
        this.tornadoRef = new WeakReference<TornadoInstance>(tornado);
        this.radius = radius;
        this.baseY = height;
        this.angularSpeed = angularSpeed;
        this.startAngle = level.random.nextFloat() * 360.0f;
        this.lifetime = 40 + this.random.nextInt(20);
        this.gravity = 0.0f;
        this.friction = 0.95f;
        this.setSize(0.2f, 0.2f);
    }

    public void tick() {
        TornadoInstance tornado = (TornadoInstance)this.tornadoRef.get();
        if (tornado == null) {
            this.remove();
            return;
        }
        float angle = this.startAngle + (tornado.getLifetimeSeconds() * 20.0f + (float)this.age) * this.angularSpeed;
        double rad = Math.toRadians(angle);
        this.setPos(tornado.position.x + Math.cos(rad) * this.radius, tornado.position.y + this.baseY, tornado.position.z + Math.sin(rad) * this.radius);
        this.yd += 0.02;
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<DebrisParticleData> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(DebrisParticleData data, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            DebrisParticle particle = new DebrisParticle(level, data.tornado(), data.radius(), data.height(), data.angularSpeed());
            try {
                particle.pickSprite(this.sprites);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return particle;
        }
    }
}

