/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import net.Gabou.projectatmosphere.client.BiomeClientTemperatureCache;
import net.Gabou.projectatmosphere.client.HUDOverlayRenderer;
import net.Gabou.projectatmosphere.compat.ColdSweatCompat;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.TemperatureMod;
import net.Gabou.projectatmosphere.compat.ToughAsNailsCompat;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.UnitFormatter;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InstrumentUtils {
    public static void displayWind(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.getDayTime());
        String msg = "Wind: " + UnitFormatter.formatWindSpeed(wind.baseSpeed()) + " at " + String.format("%.0f\u00b0", Math.toDegrees(wind.angleRadians()));
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayTemperature(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        String msg = "Current temperature: " + UnitFormatter.formatTemperature(switch (CompatHandler.getActiveTemperatureMod()) {
            case TemperatureMod.TOUGH_AS_NAILS -> ToughAsNailsCompat.getLiveTemperatureTAN(level, pos);
            case TemperatureMod.COLD_SWEAT -> ColdSweatCompat.getLiveTemperatureColdSweat(level, pos);
            default -> InstrumentUtils.getForecastTemperature(level, pos);
        });
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    private static float getForecastTemperature(Level level, BlockPos pos) {
        return BiomeClientTemperatureCache.getTemperature(AtmosphereUtils.getBiomeLocation(pos, level), level);
    }

    public static void displayHumidity(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        float humidity = ForecastOrchestrator.getCurrentHumidity(key, level.getDayTime());
        String msg = humidity < 0.01f ? "Humidity: Loading..." : "Current humidity: " + UnitFormatter.formatHumidity(humidity);
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayPressure(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        double pressure = ForecastOrchestrator.getCurrentPressure(key, level.getDayTime());
        String msg = "Current pressure: " + UnitFormatter.formatPressure(pressure);
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayStorm(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        String msg = level.isThundering() ? "Storm detected!" : (level.isRaining() ? "Rain detected." : "Skies clear.");
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }
}

