/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;

public class StorageUtils {
    public static void loadAll(ServerLevel world, Map<BiomeInstanceKey, float[][]> cache, String fileName, Gson gson) {
        Path SAVE_PATH = StorageUtils.getPerWorldSavePath(world, fileName);
        if (!Files.exists(SAVE_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(SAVE_PATH);){
            JsonObject root = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
            for (Map.Entry entry : root.entrySet()) {
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                ResourceLocation biome = ResourceLocation.parse((String)obj.get("biome").getAsString());
                BlockPos pos = AtmosphereUtils.deserializeBlockPos(obj.get("pos").getAsJsonObject());
                JsonArray arr = obj.get("data").getAsJsonArray();
                float[][] week = new float[7][2];
                for (int i = 0; i < 7; ++i) {
                    JsonArray pair = arr.get(i).getAsJsonArray();
                    week[i][0] = pair.get(0).getAsFloat();
                    week[i][1] = pair.get(1).getAsFloat();
                }
                cache.put(new BiomeInstanceKey(biome, pos), week);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void loadAll1(ServerLevel world, Map<BiomeInstanceKey, float[]> cache, String fileName, Gson gson) {
        Path SAVE_PATH = StorageUtils.getPerWorldSavePath(world, fileName);
        if (!Files.exists(SAVE_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(SAVE_PATH);){
            JsonObject root = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
            for (Map.Entry entry : root.entrySet()) {
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                ResourceLocation biome = ResourceLocation.parse((String)obj.get("biome").getAsString());
                BlockPos pos = AtmosphereUtils.deserializeBlockPos(obj.get("pos").getAsJsonObject());
                JsonArray arr = obj.get("data").getAsJsonArray();
                float[] week = new float[7];
                for (int i = 0; i < 7; ++i) {
                    JsonArray pair = arr.get(i).getAsJsonArray();
                    week[i] = pair.get(0).getAsFloat();
                }
                cache.put(new BiomeInstanceKey(biome, pos), week);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void clearCache(ServerLevel world, String fileName) {
        try {
            Files.deleteIfExists(StorageUtils.getPerWorldSavePath(world, fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveAll(ServerLevel world, Map<BiomeInstanceKey, float[][]> cache, String fileName, Gson gson) {
        JsonObject root = new JsonObject();
        for (Map.Entry<BiomeInstanceKey, float[][]> entry : cache.entrySet()) {
            BiomeInstanceKey key = entry.getKey();
            float[][] week = entry.getValue();
            JsonArray arr = new JsonArray();
            for (float[] day : week) {
                JsonArray pair = new JsonArray();
                pair.add((Number)Float.valueOf(day[0]));
                pair.add((Number)Float.valueOf(day[1]));
                arr.add((JsonElement)pair);
            }
            JsonObject obj = new JsonObject();
            obj.add("biome", (JsonElement)new JsonPrimitive(key.biomeType().toString()));
            obj.add("pos", (JsonElement)AtmosphereUtils.serializeBlockPos(key.samplePos()));
            obj.add("data", (JsonElement)arr);
            root.add(key.biomeType().toString() + "@" + key.samplePos().toShortString(), (JsonElement)obj);
        }
        try {
            Path p = StorageUtils.getPerWorldSavePath(world, fileName);
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(p, new OpenOption[0]);){
                gson.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void saveAll1(ServerLevel world, Map<BiomeInstanceKey, float[]> cache, String fileName, Gson gson) {
        JsonObject root = new JsonObject();
        for (Map.Entry<BiomeInstanceKey, float[]> entry : cache.entrySet()) {
            BiomeInstanceKey key = entry.getKey();
            float[] week = entry.getValue();
            JsonArray arr = new JsonArray();
            for (float day : week) {
                arr.add((Number)Float.valueOf(day));
            }
            JsonObject obj = new JsonObject();
            obj.add("biome", (JsonElement)new JsonPrimitive(key.biomeType().toString()));
            obj.add("pos", (JsonElement)AtmosphereUtils.serializeBlockPos(key.samplePos()));
            obj.add("data", (JsonElement)arr);
            root.add(key.biomeType().toString() + "@" + key.samplePos().toShortString(), (JsonElement)obj);
        }
        try {
            Path p = StorageUtils.getPerWorldSavePath(world, fileName);
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(p, new OpenOption[0]);){
                gson.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Path getPerWorldSavePath(ServerLevel world, String fileName) {
        String dimensionPath = world.dimension().location().getNamespace().equals("minecraft") ? world.dimension().location().getPath() : world.dimension().location().getNamespace() + "_" + world.dimension().location().getPath();
        return world.getServer().getWorldPath(LevelResource.ROOT).resolve(dimensionPath).resolve("data").resolve("projectatmosphere").resolve(fileName);
    }
}

