/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.blocks;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import java.util.List;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class StormSirenBlock
extends Block {
    private static final int CHECK_RADIUS = 400;
    private static final float INTENSITY_THRESHOLD = 6.0f;

    public StormSirenBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 200);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        List<CloudRegion> lst = CloudManager.get((Level)level).getClouds().stream().filter(cloudRegion -> CloudLibrary.getSeverityFromRessourceLocation(cloudRegion.getCloudTypeId()) >= 7).toList();
        if (lst.isEmpty()) {
            level.scheduleTick(pos, (Block)this, 200);
            return;
        }
        if (lst.stream().anyMatch(cloudRegion -> {
            double dz;
            double dx = cloudRegion.getWorldX() - (float)pos.getX();
            return dx * dx + (dz = (double)(cloudRegion.getWorldZ() - (float)pos.getZ())) * dz < 160000.0;
        })) {
            level.playSound(null, pos, (SoundEvent)ModSounds.WEATHER_SIREN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.scheduleTick(pos, (Block)this, 200);
    }
}

