/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.client;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.Gabou.projectatmosphere.async.PoolType;
import net.Gabou.projectatmosphere.client.ClientSyncLock;
import net.Gabou.projectatmosphere.client.TornadoRenderHandler;
import net.Gabou.projectatmosphere.client.sound.TornadoAudioClient;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.modules.wind.WindMath;
import net.Gabou.projectatmosphere.registry.ModParticles;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientTickHandler {
    private static RandomSource random;
    private static int tickCounter;
    private static final Set<TornadoInstance> prevTornadoes;
    private static final Set<Integer> culledRegionIds;
    private static final double CLOUD_RENDER_DISTANCE;

    private static int getRegionId(CloudRegion region) {
        return System.identityHashCode(region);
    }

    public static boolean isRegionCulled(CloudRegion region) {
        return culledRegionIds.contains(ClientTickHandler.getRegionId(region));
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Iterator<TornadoInstance> regions;
        if (!ClientSyncLock.isReady()) {
            return;
        }
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        ++tickCounter;
        TornadoManager.tick((Level)Minecraft.getInstance().level);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            CloudManager manager = CloudManager.get((Level)mc.level);
            regions = manager.getCloudGenerator().getClouds();
            double playerX = mc.player.getX();
            double playerZ = mc.player.getZ();
            Iterator iterator = regions.iterator();
            while (iterator.hasNext()) {
                double dz;
                CloudRegion region = (CloudRegion)iterator.next();
                double dx = (double)region.getWorldX() - playerX;
                double distSq = dx * dx + (dz = (double)region.getWorldZ() - playerZ) * dz;
                if (!(distSq > CLOUD_RENDER_DISTANCE * CLOUD_RENDER_DISTANCE)) continue;
                culledRegionIds.add(ClientTickHandler.getRegionId(region));
            }
            if (!culledRegionIds.isEmpty()) {
                culledRegionIds.removeIf(id -> {
                    for (CloudRegion region : regions) {
                        double dz;
                        if (ClientTickHandler.getRegionId(region) != id) continue;
                        double dx = (double)region.getWorldX() - playerX;
                        double distSq = dx * dx + (dz = (double)region.getWorldZ() - playerZ) * dz;
                        return distSq <= CLOUD_RENDER_DISTANCE * CLOUD_RENDER_DISTANCE;
                    }
                    return true;
                });
            }
        }
        if (mc.level != null) {
            HashSet<TornadoInstance> current = new HashSet<TornadoInstance>(TornadoManager.getActiveTornadoes());
            regions = current.iterator();
            while (regions.hasNext()) {
                TornadoInstance tornado = (TornadoInstance)regions.next();
                float baseVol = 0.6875f;
                TornadoAudioClient.ensure(tornado, baseVol, 140.0f);
            }
            for (TornadoInstance t : prevTornadoes) {
                if (current.contains(t)) continue;
                TornadoAudioClient.stop(t);
            }
            prevTornadoes.clear();
            prevTornadoes.addAll((Collection<TornadoInstance>)current);
        }
        if (mc.level != null && mc.level.getGameTime() % 2L == 0L) {
            for (TornadoInstance tornado : TornadoManager.getActiveTornadoes()) {
                TornadoRenderHandler.spawnDebrisParticles(tornado, mc.level);
            }
        }
        if (tickCounter % 40 == 0 && mc.level != null && mc.player != null) {
            BlockPos pos = mc.player.blockPosition();
            long gameTime = mc.level.getGameTime();
            BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, (Level)mc.level), pos);
            WindVector wind = ForecastOrchestrator.getCurrentWind(key, gameTime);
            float speed = WindMath.getSmoothGustedSpeed(wind, gameTime);
            if (speed >= 2.0f) {
                AsyncAtmosphereService.runWithCallback(PoolType.CLIENT, () -> ClientTickHandler.computeWindSpawn(pos, wind, speed), data -> {
                    if (mc.level == null) {
                        return;
                    }
                    SimpleParticleType particle = ClientTickHandler.getSeasonalLeafParticle(mc.level, data.pos(), mc.level.random);
                    SimpleParticleType windStreaks = (SimpleParticleType)ModParticles.WIND_STREAKS.get();
                    if (particle != null) {
                        mc.level.addParticle((ParticleOptions)particle, data.x(), data.y(), data.z(), data.vx(), data.vy(), data.vz());
                    }
                    mc.level.addParticle((ParticleOptions)windStreaks, data.x(), data.y(), data.z(), data.vx(), data.vy(), data.vz());
                });
            }
        }
    }

    public static SimpleParticleType getSeasonalLeafParticle(ClientLevel level, BlockPos pos, RandomSource random) {
        Season season = ClientTickHandler.getCurrentSeason(level, pos);
        List candidates = switch (season) {
            case Season.AUTUMN -> List.of((SimpleParticleType)ModParticles.TRIANGLE_ORANGE.get(), (SimpleParticleType)ModParticles.TRIANGLE_JAUNE.get(), (SimpleParticleType)ModParticles.ROUND_ORANGE.get(), (SimpleParticleType)ModParticles.ROUND_JAUNE.get(), (SimpleParticleType)ModParticles.HEART_ORANGE.get(), (SimpleParticleType)ModParticles.HEART_JAUNE.get());
            case Season.SPRING, Season.SUMMER -> List.of((SimpleParticleType)ModParticles.TRIANGLE_VERT.get(), (SimpleParticleType)ModParticles.ROUND_VERT.get(), (SimpleParticleType)ModParticles.HEART_VERT.get());
            default -> List.of();
        };
        return candidates.isEmpty() ? null : (SimpleParticleType)candidates.get(random.nextInt(candidates.size()));
    }

    public static Season getCurrentSeason(ClientLevel level, BlockPos pos) {
        return SeasonHelper.getSeasonState((Level)level).getSeason();
    }

    private static WindSpawnData computeWindSpawn(BlockPos pos, WindVector wind, float speed) {
        float angle = wind.angleRadians();
        double dx = Math.cos(angle);
        double dz = Math.sin(angle);
        double minDist = 20.0;
        double maxDist = 100.0;
        double distance = minDist + ThreadLocalRandom.current().nextDouble() * (maxDist - minDist);
        double lateralRange = 10.0;
        double lateral = (ThreadLocalRandom.current().nextDouble() * 2.0 - 1.0) * lateralRange;
        double perpX = -dz;
        double perpZ = dx;
        double spawnX = (double)pos.getX() + 0.5 - dx * distance + perpX * lateral;
        double spawnY = (double)pos.getY() + 1.5 + (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.5;
        double spawnZ = (double)pos.getZ() + 0.5 - dz * distance + perpZ * lateral;
        double vx = dx * (double)(speed *= 0.2f);
        double vy = 0.03;
        double vz = dz * (double)speed;
        return new WindSpawnData(pos, spawnX, spawnY, spawnZ, vx, vy, vz);
    }

    static {
        tickCounter = 0;
        prevTornadoes = new HashSet<TornadoInstance>();
        culledRegionIds = new HashSet<Integer>();
        CLOUD_RENDER_DISTANCE = ((Integer)AtmoCommonConfig.CLOUD_RENDER_DISTANCE.get()).intValue();
    }

    public record WindSpawnData(BlockPos pos, double x, double y, double z, double vx, double vy, double vz) {
    }
}

