/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import java.util.Map;
import java.util.function.Consumer;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.world.level.Level;

public class DailyForecastGenerator {
    public static void scheduleAll(Level world, Map<BiomeInstanceKey, BiomeForecast> forecastMap) {
        long now = world.getDayTime();
        int today = (int)(now / 24000L % 7L);
        int tomorrow = (today + 1) % 7;
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : forecastMap.entrySet()) {
            BiomeInstanceKey key = entry.getKey();
            BiomeForecast forecast = entry.getValue();
            DailyForecastGenerator.generateIfAbsent(key, forecast.getTemperature(), ForecastType.TEMPERATURE, today, tomorrow, forecast::setTemperatureDay, forecast::setTemperatureTomorrow);
            DailyForecastGenerator.generateIfAbsent(key, forecast.getHumidity(), ForecastType.HUMIDITY, today, tomorrow, forecast::setHumidityDay, forecast::setHumidityTomorrow);
            DailyForecastGenerator.generateIfAbsent(key, forecast.getPressure(), ForecastType.PRESSURE, today, tomorrow, forecast::setPressureDay, forecast::setPressureTomorrow);
            DailyForecastGenerator.generateWindIfAbsent(key, forecast.getWind(), today, tomorrow, forecast::setWindDay, forecast::setWindTomorrow);
            DailyForecastGenerator.generateIfAbsent(key, forecast.getStormChance(), ForecastType.STORM, today, tomorrow, forecast::setStormChanceDay, forecast::setStormChanceTomorrow);
        }
    }

    private static void generateIfAbsent(BiomeInstanceKey key, float[][] week, ForecastType type, long todayTick, long tomorrowTick, Consumer<float[]> todaySetter, Consumer<float[]> tomorrowSetter) {
        float[] tomorrow;
        float[] today;
        if (week == null) {
            return;
        }
        int todayIdx = (int)(todayTick / 24000L % 7L);
        int tomorrowIdx = (int)(tomorrowTick / 24000L % 7L);
        if (todaySetter != null && (today = DailyForecastGenerator.buildDailyCurve(week[todayIdx], type)) != null) {
            todaySetter.accept(today);
        }
        if (tomorrowSetter != null && (tomorrow = DailyForecastGenerator.buildDailyCurve(week[tomorrowIdx], type)) != null) {
            tomorrowSetter.accept(tomorrow);
        }
    }

    private static void generateWindIfAbsent(BiomeInstanceKey key, WindVector[] week, long todayTick, long tomorrowTick, Consumer<WindVector> todaySetter, Consumer<WindVector> tomorrowSetter) {
        if (week == null) {
            return;
        }
        int todayIdx = (int)(todayTick / 24000L % 7L);
        int tomorrowIdx = (int)(tomorrowTick / 24000L % 7L);
        if (todaySetter != null && week[todayIdx] != null) {
            todaySetter.accept(week[todayIdx]);
        }
        if (tomorrowSetter != null && week[tomorrowIdx] != null) {
            tomorrowSetter.accept(week[tomorrowIdx]);
        }
    }

    public static float[] buildDailyCurve(float[] minMax, ForecastType type) {
        float min = minMax[0];
        float max = minMax[1];
        float[] curve = new float[240];
        for (int i = 0; i < 240; ++i) {
            float factor;
            float t = (float)i / 239.0f;
            switch (type) {
                case TEMPERATURE: 
                case PRESSURE: {
                    float theta = (float)(Math.PI * (double)t);
                    factor = (1.0f - (float)Math.cos(theta)) * 0.5f;
                    break;
                }
                case HUMIDITY: {
                    factor = t < 0.25f ? 1.0f - (float)Math.pow(t * 4.0f, 0.8) : (t < 0.75f ? 0.1f + 0.9f * (1.0f - (float)Math.sin(Math.PI * (double)(t - 0.25f) / 0.5)) : 0.1f + (float)Math.pow((t - 0.75f) * 4.0f, 0.8));
                    factor = 1.0f - factor;
                    break;
                }
                case STORM: {
                    float theta = (float)(Math.PI * (double)Math.min(1.0f, t * 1.1f));
                    factor = (1.0f - (float)Math.cos(theta)) * 0.6f;
                    if (!(t < 0.2f)) break;
                    factor *= t * 5.0f;
                    break;
                }
                default: {
                    factor = 0.0f;
                }
            }
            curve[i] = min + (max - min) * factor;
        }
        return curve;
    }

    public static void scheduleGenerationForTodayAndTomorrow() {
        Map<BiomeInstanceKey, BiomeForecast> allForecasts = ForecastGenerator.getForecastMap();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : allForecasts.entrySet()) {
            BiomeInstanceKey key = entry.getKey();
            BiomeForecast forecast = entry.getValue();
            float[][] temperature = forecast.getTemperature();
            float[][] pressure = forecast.getPressure();
            float[][] humidity = forecast.getHumidity();
            WindVector[] wind = forecast.getWind();
            if (temperature != null && temperature.length > 1) {
                forecast.setTemperatureDay(DailyForecastGenerator.interpolateCurve(temperature[0], temperature[1]));
                forecast.setTemperatureTomorrow(DailyForecastGenerator.interpolateCurve(temperature[1], temperature[2 % temperature.length]));
            }
            if (pressure != null && pressure.length > 1) {
                forecast.setPressureDay(DailyForecastGenerator.interpolateCurve(pressure[0], pressure[1]));
                forecast.setPressureTomorrow(DailyForecastGenerator.interpolateCurve(pressure[1], pressure[2 % pressure.length]));
            }
            if (humidity != null && humidity.length > 1) {
                forecast.setHumidityDay(DailyForecastGenerator.interpolateCurve(humidity[0], humidity[1]));
                forecast.setHumidityTomorrow(DailyForecastGenerator.interpolateCurve(humidity[1], humidity[2 % humidity.length]));
            }
            if (wind == null || wind.length <= 1) continue;
            forecast.setWindDay(wind[0]);
            forecast.setWindTomorrow(wind[1]);
        }
    }

    private static float[] interpolateCurve(float[] today, float[] next) {
        float min1 = today[0];
        float max1 = today[1];
        float min2 = next[0];
        float max2 = next[1];
        float[] curve = new float[240];
        for (int i = 0; i < 240; ++i) {
            float t = (float)i / 239.0f;
            float dayFactor = (1.0f - (float)Math.cos(Math.PI * (double)t)) * 0.5f;
            float blendedMin = min1 + (min2 - min1) * t;
            float blendedMax = max1 + (max2 - max1) * t;
            curve[i] = blendedMin + (blendedMax - blendedMin) * dayFactor;
        }
        return curve;
    }
}

