/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class WindLeafParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private static final double DESIRED_TRAVEL_BLOCKS = 40.0;

    protected WindLeafParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = sprites;
        this.gravity = 0.002f;
        this.friction = 0.98f;
        this.xd = xSpeed;
        this.yd = ySpeed * (double)0.3f + (double)(this.random.nextFloat() * 0.02f);
        this.zd = zSpeed;
        this.lifetime = 200;
        this.setSize(0.1f, 0.1f);
        try {
            this.setSpriteFromAge(sprites);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.oRoll = this.roll = this.random.nextFloat() * (float)Math.PI * 2.0f;
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += 0.02f + this.random.nextFloat() * 0.01f;
        if (this.age % 5 == 0) {
            this.yd += (double)((this.random.nextFloat() - 0.5f) * 0.003f);
        }
        if (this.age > this.lifetime - 40) {
            this.alpha = (float)(this.lifetime - this.age) / 40.0f;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WindLeafParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

