/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import com.google.gson.JsonObject;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class AtmosphereUtils {
    public static JsonObject serializeBlockPos(BlockPos pos) {
        JsonObject obj = new JsonObject();
        obj.addProperty("x", (Number)pos.getX());
        obj.addProperty("y", (Number)pos.getY());
        obj.addProperty("z", (Number)pos.getZ());
        return obj;
    }

    public static BlockPos deserializeBlockPos(JsonObject obj) {
        int x = obj.get("x").getAsInt();
        int y = obj.get("y").getAsInt();
        int z = obj.get("z").getAsInt();
        return new BlockPos(x, y, z);
    }

    public static BiomeInstanceKey getBiomeKey(ServerLevel level, BlockPos pos) {
        ResourceLocation biomeId = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)level.getBiome(pos).value()));
        return new BiomeInstanceKey(biomeId, pos);
    }

    public static ResourceLocation getBiomeLocation(BlockPos pos, Level world) {
        return ((ResourceKey)world.getBiome(pos).unwrapKey().get()).location();
    }

    public static float toMinecraftSimple(float celsius, boolean isTropical) {
        if (isTropical) {
            return 1.8f;
        }
        return celsius <= 0.0f ? 0.0f : 0.5f;
    }
}

