/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.compat;

import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;

public class LegendarySurvivalCompat {
    private static final float MIN_DAILY_SWING = 2.5f;
    private static final float MAX_DAILY_SWING = 6.0f;
    private static final float DAILY_JITTER = 0.5f;

    public static float[][] injectForecastForLSO(BiomeInstanceKey key, ServerLevel level) {
        BlockPos sample = key.samplePos();
        float baseTemp = TemperatureUtil.getWorldTemperature((Level)level, (BlockPos)sample);
        return LegendarySurvivalCompat.generateMinMaxCurve(baseTemp, level.m_213780_());
    }

    private static float[][] generateMinMaxCurve(float base, RandomSource random) {
        float[][] result = new float[7][2];
        float overallSwing = Mth.m_14179_((float)random.m_188501_(), (float)2.5f, (float)6.0f);
        for (int i = 0; i < 7; ++i) {
            float dayOffset = (float)Math.sin((double)((float)i / 6.0f) * Math.PI);
            float swing = dayOffset * overallSwing;
            float minTemp = (float)((double)(base - swing / 2.0f) + random.m_188583_() * 0.5);
            float maxTemp = (float)((double)(base + swing / 2.0f) + random.m_188583_() * 0.5);
            result[i][0] = (float)Math.round(minTemp * 10.0f) / 10.0f;
            result[i][1] = (float)Math.round(maxTemp * 10.0f) / 10.0f;
        }
        return result;
    }

    public static float getLiveTemperature(Level level, BlockPos pos) {
        return TemperatureUtil.getWorldTemperature((Level)level, (BlockPos)pos);
    }

    public static boolean isLoaded() {
        return CompatHandler.isLegendarySurvivalLoaded();
    }
}

