/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.compat.auroras;

import net.Gabou.projectatmosphere.compat.temperature.ClientTemperatureResolver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

@OnlyIn(value=Dist.CLIENT)
public final class AuroraSeasonHelper {
    private AuroraSeasonHelper() {
    }

    public static float computeSeasonalFactor(Level level) {
        if (level == null) {
            return 1.0f;
        }
        try {
            Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
            Season season = subSeason.getSeason();
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.WINTER -> 1.4f;
                case Season.AUTUMN -> 1.1f;
                case Season.SPRING -> 0.85f;
                case Season.SUMMER -> 0.55f;
            };
        }
        catch (Exception ignored) {
            return 1.0f;
        }
    }

    public static float computeTemperatureFactor(Level level, BlockPos pos) {
        if (level == null) {
            return 1.0f;
        }
        Holder biomeHolder = level.m_204166_(pos);
        Biome biome = (Biome)biomeHolder.m_203334_();
        if (biome.m_198904_(pos)) {
            return 1.35f;
        }
        float tempCelsius = ClientTemperatureResolver.getCelsius(level, pos);
        float normalized = (15.0f - tempCelsius) / 20.0f;
        float scaled = 0.6f + Mth.m_14036_((float)normalized, (float)0.0f, (float)1.0f) * 0.75f;
        return Mth.m_14036_((float)scaled, (float)0.45f, (float)1.35f);
    }

    public static float combinedBoost(Level level, BlockPos pos) {
        float seasonal = AuroraSeasonHelper.computeSeasonalFactor(level);
        float thermal = AuroraSeasonHelper.computeTemperatureFactor(level, pos);
        return Mth.m_14036_((float)(seasonal * thermal), (float)0.45f, (float)1.5f);
    }
}

