/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.compat.rainbows;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.network.NetworkHandler;
import net.Gabou.projectatmosphere.network.RainfallUpdatePacket;
import net.Gabou.projectatmosphere.util.WeatherType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public final class RainbowRainBridge {
    private static final Map<ResourceKey<Level>, Float> LAST_LEVELS = new HashMap<ResourceKey<Level>, Float>();
    private static final float EPSILON = 0.02f;

    private RainbowRainBridge() {
    }

    public static void sync(ServerLevel level, CloudGenerator generator) {
        float rainLevel = RainbowRainBridge.computeRainLevel(generator);
        ResourceKey dimension = level.m_46472_();
        Float previous = LAST_LEVELS.get(dimension);
        if (previous != null && Math.abs(previous.floatValue() - rainLevel) <= 0.02f) {
            return;
        }
        LAST_LEVELS.put((ResourceKey<Level>)dimension, Float.valueOf(rainLevel));
        RainfallUpdatePacket packet = new RainfallUpdatePacket(dimension.m_135782_(), rainLevel);
        NetworkHandler.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)packet);
    }

    public static void clear(ResourceKey<Level> dimension) {
        LAST_LEVELS.remove(dimension);
    }

    public static void sendSnapshot(ServerPlayer player, ServerLevel level, CloudGenerator generator) {
        ResourceKey dimension = level.m_46472_();
        float rainLevel = LAST_LEVELS.getOrDefault(dimension, Float.valueOf(RainbowRainBridge.computeRainLevel(generator))).floatValue();
        LAST_LEVELS.put((ResourceKey<Level>)dimension, Float.valueOf(rainLevel));
        RainfallUpdatePacket packet = new RainfallUpdatePacket(dimension.m_135782_(), rainLevel);
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    private static float computeRainLevel(CloudGenerator generator) {
        List clouds = generator.getClouds();
        if (clouds.isEmpty()) {
            return 0.0f;
        }
        float total = 0.0f;
        int rainyCount = 0;
        for (CloudRegion region : clouds) {
            ResourceLocation type = region.getCloudTypeId();
            if (!WeatherType.isRainy(type)) continue;
            ++rainyCount;
            int severity = CloudLibrary.getSeverityFromRessourceLocation(type);
            total += (float)Math.max(1, severity) / 7.0f;
        }
        if (rainyCount == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)(total / (float)rainyCount), (float)0.0f, (float)1.0f);
    }
}

