/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.compat.rainbows;

import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RainbowWeatherTracker {
    private static final Map<ResourceKey<Level>, TrackerState> STATES = new HashMap<ResourceKey<Level>, TrackerState>();
    private static boolean enabled;

    private RainbowWeatherTracker() {
    }

    public static void setEnabled(boolean value) {
        enabled = value;
        if (!value) {
            STATES.clear();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void tick(Minecraft minecraft) {
        if (!enabled) {
            return;
        }
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            if (minecraft.f_91073_ == null) {
                STATES.clear();
            }
            return;
        }
        ClientLevel level = minecraft.f_91073_;
        ResourceKey dimension = level.m_46472_();
        TrackerState state = STATES.computeIfAbsent((ResourceKey<Level>)dimension, key -> new TrackerState());
        if (!state.isServerAuthoritative()) {
            boolean raining = RainbowWeatherTracker.isRainingAt(level, minecraft.f_91074_.m_20183_());
            state.applyFallback(raining);
        }
        state.step();
    }

    private static boolean isRainingAt(ClientLevel level, BlockPos pos) {
        try {
            return CloudManager.get((Level)level).isRainingAt(pos);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static float getRainLevel(ResourceKey<Level> dimension) {
        TrackerState state = STATES.get(dimension);
        return state != null ? state.rainVisual : 0.0f;
    }

    public static boolean consumeRainStop(ResourceKey<Level> dimension) {
        TrackerState state = STATES.get(dimension);
        return state != null && state.consumeStopFlag();
    }

    public static void applyServerUpdate(ResourceKey<Level> dimension, float rainLevel) {
        if (!enabled) {
            return;
        }
        TrackerState state = STATES.computeIfAbsent(dimension, key -> new TrackerState());
        state.setServerTarget(rainLevel);
    }

    private static final class TrackerState {
        private static final float STEP = 0.05f;
        private float target;
        private float rainVisual;
        private boolean stopFlag;
        private boolean serverAuthoritative;
        private boolean wasTargetRaining;

        private TrackerState() {
        }

        void setServerTarget(float value) {
            this.serverAuthoritative = true;
            this.applyTarget(value);
        }

        void applyFallback(boolean raining) {
            if (this.serverAuthoritative) {
                return;
            }
            this.applyTarget(raining ? 1.0f : 0.0f);
        }

        private void applyTarget(float value) {
            boolean newRaining;
            float clamped = Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
            if (Math.abs(clamped - this.target) <= 5.0E-4f) {
                return;
            }
            boolean bl = newRaining = clamped > 0.01f;
            if (this.wasTargetRaining && !newRaining) {
                this.stopFlag = true;
            }
            this.wasTargetRaining = newRaining;
            this.target = clamped;
        }

        void step() {
            float delta = this.target - this.rainVisual;
            this.rainVisual = Math.abs(delta) > 0.05f ? (this.rainVisual += Math.copySign(0.05f, delta)) : this.target;
        }

        boolean consumeStopFlag() {
            if (this.stopFlag) {
                this.stopFlag = false;
                return true;
            }
            return false;
        }

        boolean isServerAuthoritative() {
            return this.serverAuthoritative;
        }
    }
}

