/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.event;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.ServerCloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.ServerCloudManager;
import net.Gabou.projectatmosphere.blocks.BlockManager;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.rainbows.RainbowRainBridge;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.manager.SimpleCloudSpawner;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projectatmosphere")
public class EventHandler {
    private static final int MIN_TICKS_BETWEEN_DUST_SPAWN = 5000;
    private static final int MIN_TICKS_BETWEEN_TEMPESTA = 2000;
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase != TickEvent.Phase.END || event.level.f_46443_ || !((level = event.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!AtmosphereManager.isInitialGenerationDone) {
            return;
        }
        if (serverLevel.m_6907_().isEmpty()) {
            return;
        }
        if (!serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        ServerCloudManager cloudManager = (ServerCloudManager)CloudManager.get((Level)serverLevel);
        ServerCloudGenerator generator = cloudManager.getCloudGenerator();
        AtmosphereManager.tick(serverLevel);
        if (generator.getTicksTillNextGen() <= 0) {
            SimpleCloudSpawner.trySpawnClouds(serverLevel, (CloudGenerator)generator);
        }
        if (CompatHandler.isRainbowsLoaded()) {
            RainbowRainBridge.sync(serverLevel, (CloudGenerator)generator);
        }
        if (!((Boolean)AtmoCommonConfig.ENABLE_STORM_DEBRIS.get()).booleanValue()) {
            return;
        }
        if (tickCounter % 2000 == 0) {
            int cloudY = cloudManager.getCloudHeight();
            for (CloudRegion region : generator.getClouds()) {
                int severity = CloudLibrary.getSeverityFromRessourceLocation(region.getCloudTypeId());
                if (severity <= 5) continue;
                BlockPos pos = new BlockPos((int)region.getWorldX(), cloudY, (int)region.getWorldZ());
                BlockManager.simulateTempesta(serverLevel, pos, (int)region.getRadius());
            }
        }
        ++tickCounter;
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = player2.m_284548_();
        if (CompatHandler.isRainbowsLoaded() && level.m_46472_().equals((Object)event.getTo())) {
            ServerCloudManager cloudManager = (ServerCloudManager)CloudManager.get((Level)level);
            RainbowRainBridge.sendSnapshot(player2, level, (CloudGenerator)cloudManager.getCloudGenerator());
        }
    }

    public static void onRegenerate() {
        tickCounter = 0;
    }
}

