/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import dev.nonamecrackers2.simpleclouds.common.cloud.SimpleCloudsConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.async.BiomeSampler;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.ToughAsNailsCompat;
import net.Gabou.projectatmosphere.manager.ForecastPointerRegistry;
import net.Gabou.projectatmosphere.manager.SandStormManager;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.humidity.HumidityGenerator;
import net.Gabou.projectatmosphere.modules.pressure.PressureGenerator;
import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeManager;
import net.Gabou.projectatmosphere.modules.temperature.util.TemperatureGenerator;
import net.Gabou.projectatmosphere.modules.temperature.variation.VariationGenerator;
import net.Gabou.projectatmosphere.modules.wind.WindGenerator;
import net.Gabou.projectatmosphere.network.BiomeDayTemperaturePacket;
import net.Gabou.projectatmosphere.network.NetworkHandler;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraftforge.network.PacketDistributor;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class ForecastGenerator {
    private static final int SAMPLE_STEP = 128;
    static long seed = 0L;
    static final boolean sandStormLoaded = CompatHandler.isSandStormsLoaded();
    public static final int MAX_POSITIONS_PER_BIOME = CompatHandler.isToughAsNailsLoaded() ? 25 : 40;
    static final int RADIUS = SimpleCloudsConstants.SPAWN_RADIUS;
    static final Set<BiomeInstanceKey> biomeSamples = ConcurrentHashMap.newKeySet();
    private static Map<ResourceLocation, List<BiomeInstanceKey>> biomeIndex = new ConcurrentHashMap<ResourceLocation, List<BiomeInstanceKey>>();
    private static final Map<ResourceLocation, Integer> biomeSampleCounts = new ConcurrentHashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, BiomeForecast> AVERAGE_FORECASTS = new ConcurrentHashMap<ResourceLocation, BiomeForecast>();
    static final Map<BiomeInstanceKey, BiomeForecast> FORECAST_MAP = new ConcurrentHashMap<BiomeInstanceKey, BiomeForecast>();
    private static final Map<ResourceLocation, List<BiomeForecast>> grouped = new ConcurrentHashMap<ResourceLocation, List<BiomeForecast>>();

    public static Map<ResourceLocation, List<BiomeInstanceKey>> getBiomeIndex() {
        return Collections.unmodifiableMap(biomeIndex);
    }

    public static void groupBiomeByType() {
        biomeIndex = biomeSamples.stream().collect(Collectors.groupingBy(BiomeInstanceKey::biomeType));
    }

    static void computeAverageForecastsByBiomeType() {
        HashMap<ResourceLocation, float[]> map = new HashMap<ResourceLocation, float[]>();
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setTemperature(ForecastGenerator.averageWeek(list, BiomeForecast::getTemperature));
            avg.setHumidity(ForecastGenerator.averageWeek(list, BiomeForecast::getHumidity));
            avg.setPressure(ForecastGenerator.averageWeek(list, BiomeForecast::getPressure));
            avg.setWind(ForecastGenerator.averageWindWeek(list, BiomeForecast::getWind));
            avg.setBiomeKey(list.get(0).getBiomeKey());
            float representative = ForecastGenerator.deriveRepresentativeTemperature(avg);
            map.put(entry.getKey(), ForecastGenerator.buildFlatCurve(representative));
        }
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BiomeDayTemperaturePacket(map));
    }

    private static void computeAverageTemperatureWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setTemperature(ForecastGenerator.averageWeek(list, BiomeForecast::getTemperature));
        }
    }

    private static void computeAverageHumidityWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setHumidity(ForecastGenerator.averageWeek(list, BiomeForecast::getHumidity));
        }
    }

    private static void computeAveragePressureWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setPressure(ForecastGenerator.averageWeek(list, BiomeForecast::getPressure));
        }
    }

    private static void computeAverageWindWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setWind(ForecastGenerator.averageWindWeek(list, BiomeForecast::getWind));
        }
    }

    public static void groupForecastsByBiome() {
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            ResourceLocation biomeType = entry.getKey().biomeType();
            grouped.computeIfAbsent(biomeType, k -> new ArrayList()).add(entry.getValue());
        }
    }

    public static BiomeForecast getAverageForecast(ResourceLocation biomeType) {
        return AVERAGE_FORECASTS.get(biomeType);
    }

    public static Set<BiomeInstanceKey> getBiomeSamples() {
        return biomeSamples;
    }

    static void clearBiomeSamples() {
        biomeSamples.clear();
        biomeIndex.clear();
    }

    static void generateForecastForSavedRegion(ServerLevel level) {
        SandStormManager.dailyAndSand(level);
    }

    static void generateForecastForRegion(BlockPos center, ServerLevel level) {
        ResourceLocation biomeId;
        long start = System.nanoTime();
        long day = AsyncAtmosphereService.callOnMainThread(() -> level.m_46468_() / 24000L);
        Season season = AsyncAtmosphereService.callOnMainThread(() -> SeasonHelper.getSeasonState((Level)level).getSeason());
        BiomeSource biomeSource = AsyncAtmosphereService.callOnMainThread(() -> level.m_7726_().m_8481_().m_62218_());
        BiomeSampler sampler = new BiomeSampler(ProjectAtmosphere.seed, level.m_9598_(), biomeSource);
        for (int dx = -RADIUS; dx <= RADIUS; dx += 128) {
            for (int dz = -RADIUS; dz <= RADIUS; dz += 128) {
                int count;
                BlockPos samplePos = center.m_7918_(dx, 0, dz);
                biomeId = sampler.getBiomeId(samplePos.m_123341_(), samplePos.m_123342_(), samplePos.m_123343_());
                if (biomeId.m_135815_().contains("cave") || (count = biomeSampleCounts.getOrDefault(biomeId, 0).intValue()) >= MAX_POSITIONS_PER_BIOME) continue;
                biomeSamples.add(new BiomeInstanceKey(biomeId, samplePos));
                biomeSampleCounts.put(biomeId, count + 1);
            }
        }
        biomeIndex = biomeSamples.stream().collect(Collectors.groupingBy(BiomeInstanceKey::biomeType));
        if (CompatHandler.isToughAsNailsLoaded()) {
            Iterator<Map.Entry<BiomeInstanceKey, BiomeForecast>> processed = new HashSet();
            for (BiomeInstanceKey key : biomeSamples) {
                biomeId = key.biomeType();
                if (!processed.add((Map.Entry<BiomeInstanceKey, BiomeForecast>)biomeId)) continue;
                long sampleTime = System.currentTimeMillis();
                float[][] forecast = ToughAsNailsCompat.injectForecastForTAN(key, level);
                BiomeForecast bf = new BiomeForecast();
                bf.setTemperature(forecast);
                bf.setToughAsNailsFlag(true);
                bf.setBiomeKey(key);
                ForecastGenerator.putForecast(key, bf);
                long endTime = System.currentTimeMillis();
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Tough as Nail forecast for " + String.valueOf(biomeId) + " at " + String.valueOf(key.samplePos()) + " took " + (endTime - sampleTime) + " ms");
            }
            ForecastGenerator.groupForecastsByBiome();
        } else {
            for (BiomeInstanceKey key : biomeSamples) {
                BiomeForecast forecast = new BiomeForecast();
                forecast.setTemperature(ForecastGenerator.generateTemperature(key, level));
                forecast.setBiomeKey(key);
                ForecastGenerator.putForecast(key, forecast);
            }
            ForecastGenerator.groupForecastsByBiome();
        }
        ForecastGenerator.computeAverageTemperatureWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            entry.getValue().setHumidity(ForecastGenerator.generateHumidity(entry.getKey(), level, day));
        }
        ForecastGenerator.computeAverageHumidityWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            entry.getValue().setPressure(ForecastGenerator.generatePressure(entry.getKey(), day));
        }
        ForecastGenerator.computeAveragePressureWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            entry.getValue().setWind(ForecastGenerator.generateWind(entry.getKey()));
        }
        ForecastGenerator.computeAverageWindWeek();
        SandStormManager.dailyAndSand(level);
        long end = System.nanoTime();
        long durationMs = (end - start) / 1000000L;
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Forecast region generation took " + durationMs + " ms.");
    }

    private static float[][] generateTemperature(BiomeInstanceKey key, ServerLevel level) {
        return SpikeManager.applySpikeLogic(key, VariationGenerator.applyVariationToWeek(TemperatureGenerator.generateWeekForecast(level, key.samplePos(), key.biomeType())));
    }

    private static float[][] generateHumidity(BiomeInstanceKey key, ServerLevel level, Long day) {
        return HumidityGenerator.generateWeekForecast(level, key, day);
    }

    private static float[][] generatePressure(BiomeInstanceKey key, Long day) {
        return PressureGenerator.generateWeekForecast(key, day);
    }

    private static WindVector[] generateWind(BiomeInstanceKey key) {
        return WindGenerator.generateWindWeek(key);
    }

    public static Map<BiomeInstanceKey, BiomeForecast> getForecastMap() {
        return FORECAST_MAP;
    }

    static void clearForecasts() {
        FORECAST_MAP.clear();
        grouped.clear();
        biomeSamples.clear();
        biomeIndex.clear();
        biomeSampleCounts.clear();
        AVERAGE_FORECASTS.clear();
        AtmosphericStateRegistry.clear();
        SandStormManager.clearSandstormForecasts();
        ForecastPointerRegistry.clear();
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Cleared all forecasts and samples.");
    }

    static void putForecast(BiomeInstanceKey key, BiomeForecast forecast) {
        FORECAST_MAP.put(key, forecast);
        if (biomeSamples.add(key)) {
            biomeSampleCounts.put(key.biomeType(), biomeSampleCounts.getOrDefault(key.biomeType(), 0) + 1);
        }
        AtmosphericStateRegistry.initializeState(key, forecast);
    }

    static BiomeForecast getForecast(BiomeInstanceKey key) {
        return FORECAST_MAP.get(key);
    }

    static float getHumidityValue(BiomeInstanceKey key, long tick) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null) {
            return 0.0f;
        }
        return state.getHumidityPercent();
    }

    static float getTemperatureValue(BiomeInstanceKey key, long tick) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null) {
            return 0.0f;
        }
        return state.getTemperature();
    }

    static float getPressureValue(BiomeInstanceKey key, long tick) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null) {
            return 0.0f;
        }
        return state.getPressure();
    }

    static WindVector getWindValue(BiomeInstanceKey key, long worldTime) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null || state.getWind() == null) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        return state.getWind();
    }

    public static BiomeForecast getClosestValidForecast(BiomeInstanceKey key, ForecastType type) {
        return ForecastPointerRegistry.getPointer(key);
    }

    private static float[][] averageWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, float[][]> extractor) {
        int days = 7;
        int cols = 2;
        float[][] result = new float[days][cols];
        for (BiomeForecast f : forecasts) {
            float[][] data = extractor.apply(f);
            if (data == null) continue;
            for (int d = 0; d < days; ++d) {
                for (int c = 0; c < cols; ++c) {
                    float[] fArray = result[d];
                    int n = c;
                    fArray[n] = fArray[n] + data[d][c];
                }
            }
        }
        int size = forecasts.size();
        for (int d = 0; d < days; ++d) {
            int c = 0;
            while (c < cols) {
                float[] fArray = result[d];
                int n = c++;
                fArray[n] = fArray[n] / (float)size;
            }
        }
        return result;
    }

    private static WindVector averageWind(List<BiomeForecast> forecasts, Function<BiomeForecast, WindVector> extractor) {
        if (forecasts.isEmpty()) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        float sumX = 0.0f;
        float sumZ = 0.0f;
        float sumGust = 0.0f;
        for (BiomeForecast f : forecasts) {
            WindVector wind = f.getWindDay();
            if (wind == null) continue;
            float angle = wind.angleRadians();
            float speed = wind.baseSpeed();
            sumX += speed * (float)Math.cos(angle);
            sumZ += speed * (float)Math.sin(angle);
            sumGust += wind.gustSpeed();
        }
        int size = forecasts.size();
        float avgX = sumX / (float)size;
        float avgZ = sumZ / (float)size;
        float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
        float avgAngle = (float)Math.atan2(avgZ, avgX);
        float avgGust = sumGust / (float)size;
        return new WindVector(avgSpeed, avgAngle, avgGust);
    }

    private static WindVector[] averageWindWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, WindVector[]> extractor) {
        Object[] result = new WindVector[7];
        if (forecasts.isEmpty()) {
            Arrays.fill(result, WindVector.fromBase(0.0f, 0.0f));
            return result;
        }
        for (int day = 0; day < 7; ++day) {
            float sumX = 0.0f;
            float sumZ = 0.0f;
            float sumGust = 0.0f;
            int count = 0;
            for (BiomeForecast forecast : forecasts) {
                WindVector wind;
                WindVector[] windWeek = extractor.apply(forecast);
                if (windWeek == null || windWeek.length != 7 || (wind = windWeek[day]) == null) continue;
                float speed = wind.baseSpeed();
                float angle = wind.angleRadians();
                float gust = wind.gustSpeed();
                sumX += speed * (float)Math.cos(angle);
                sumZ += speed * (float)Math.sin(angle);
                sumGust += gust;
                ++count;
            }
            if (count > 0) {
                float avgX = sumX / (float)count;
                float avgZ = sumZ / (float)count;
                float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
                float avgAngle = (float)Math.atan2(avgZ, avgX);
                float avgGust = sumGust / (float)count;
                result[day] = new WindVector(avgSpeed, avgAngle, avgGust);
                continue;
            }
            result[day] = WindVector.fromBase(0.0f, 0.0f);
        }
        return result;
    }

    private static float deriveRepresentativeTemperature(BiomeForecast avg) {
        RegionAtmosphereState state;
        if (avg.getBiomeKey() != null && (state = AtmosphericStateRegistry.getState(avg.getBiomeKey())) != null) {
            return state.getTemperature();
        }
        return ForecastGenerator.averageDailyMidpoint(avg.getTemperature());
    }

    private static float[] buildFlatCurve(float value) {
        float[] arr = new float[24];
        Arrays.fill(arr, value);
        return arr;
    }

    private static float averageDailyMidpoint(float[][] week) {
        if (week == null || week.length == 0) {
            return 0.0f;
        }
        float sum = 0.0f;
        int count = 0;
        for (float[] day : week) {
            if (day == null || day.length == 0) continue;
            sum = day.length == 1 ? (sum += day[0]) : (sum += (day[0] + day[Math.min(1, day.length - 1)]) * 0.5f);
            ++count;
        }
        return count == 0 ? 0.0f : sum / (float)count;
    }
}

