/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.data.TornadoStorageManager;
import net.Gabou.projectatmosphere.manager.ForecastDataStorage;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.manager.SandStormManager;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.CloudManager;
import net.Gabou.projectatmosphere.modules.atmosphere.CycloneManager;
import net.Gabou.projectatmosphere.modules.atmosphere.RainSystem;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.atmosphere.SunlightController;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneInstance;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneManager;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneState;
import net.Gabou.projectatmosphere.modules.tornado.GlassDamageManager;
import net.Gabou.projectatmosphere.modules.tornado.TornadoProbabilityManager;
import net.Gabou.projectatmosphere.modules.wind.FloatRange;
import net.Gabou.projectatmosphere.modules.wind.WindEngine;
import net.Gabou.projectatmosphere.modules.wind.WindForecast;
import net.Gabou.projectatmosphere.modules.wind.WindForecastPart;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ForecastOrchestrator {
    private static final int MIN_DISTANCE_BETWEEN_CENTERS = ForecastGenerator.RADIUS / 2;
    private static long lastTornadoCheckTick = 0L;
    private static volatile boolean REGENERATING = false;
    private static final ConcurrentLinkedQueue<Runnable> POST_REGEN_QUEUE = new ConcurrentLinkedQueue();
    private static Map<UUID, Set<BiomeInstanceKey>> activePlayerBiomeKeys = new HashMap<UUID, Set<BiomeInstanceKey>>();
    private static final boolean sandStormLoaded = CompatHandler.isSandStormsLoaded();

    public static boolean isRegenerating() {
        return REGENERATING;
    }

    public static void runAfterRegen(Runnable task) {
        if (task == null) {
            return;
        }
        if (REGENERATING) {
            POST_REGEN_QUEUE.add(task);
        } else {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean onServerStart(ServerLevel level) {
        ForecastDataStorage.loadAll(level);
        TornadoStorageManager.load(level);
        ForecastGenerator.seed = level.m_7328_();
        if (ForecastDataStorage.hasCenterData() && ForecastDataStorage.hasForecastData()) {
            try {
                ForecastGenerator.generateForecastForSavedRegion(level);
                ForecastOrchestrator.initializeDynamicSystems(level);
                return true;
            }
            catch (Exception e) {
                ProjectAtmosphere.LOGGER.error("[Atmosphere] Failed to load saved forecast data. Regenerating from spawn...", (Throwable)e);
                ForecastDataStorage.clearAll(level);
                ForecastGenerator.clearForecasts();
                ForecastGenerator.generateForecastForRegion(level.m_220360_(), level);
                ForecastOrchestrator.initializeDynamicSystems(level);
                return true;
            }
        }
        if (!ForecastDataStorage.playerData.isEmpty()) {
            for (BlockPos pos : ForecastDataStorage.playerData.values()) {
                ForecastGenerator.generateForecastForRegion(pos, level);
            }
        } else {
            ForecastGenerator.generateForecastForRegion(level.m_220360_(), level);
        }
        ForecastOrchestrator.initializeDynamicSystems(level);
        return true;
    }

    public static void onServerStop(ServerLevel level) {
        ForecastDataStorage.saveAll(level);
        TornadoStorageManager.save(level);
        ForecastGenerator.clearForecasts();
    }

    public static void onPlayerLogin(ServerPlayer player, ServerLevel level) {
        UUID uuid = player.m_20148_();
        BlockPos playerPos = player.m_20183_();
        ForecastOrchestrator.getNearbyBiomeKeys(level, player, 500.0);
        long start = System.nanoTime();
        if (!ForecastDataStorage.playerData.containsKey(uuid)) {
            boolean shouldGenerate = true;
            for (BlockPos center : ForecastDataStorage.playerData.values()) {
                if (center.m_123333_((Vec3i)playerPos) >= MIN_DISTANCE_BETWEEN_CENTERS) continue;
                shouldGenerate = false;
                break;
            }
            if (shouldGenerate) {
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Player " + player.m_7755_().getString());
                ForecastDataStorage.playerData.put(uuid, playerPos);
                SimpleCloudsCompat.doInitialGenWithWeather(playerPos.m_123341_(), playerPos.m_123343_(), level);
            }
        }
        SimpleCloudsCompat.setIsInit(true);
        long end = System.nanoTime();
        long durationMs = (end - start) / 1000000L;
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Forecast data prepared for player {} in {} ms", (Object)player.m_7755_().getString(), (Object)durationMs);
    }

    public static void regenerateAround(ServerLevel level, BlockPos pos) {
        ForecastOrchestrator.updateForecast(level, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAndRegenerate(ServerLevel level) {
        REGENERATING = true;
        try {
            ForecastGenerator.clearForecasts();
            ForecastOrchestrator.clearActiveBiomeKeys();
            ForecastDataStorage.playerData.clear();
            List players = AsyncAtmosphereService.callOnMainThread(() -> ((ServerLevel)level).m_6907_());
            HashSet<BlockPos> centers = new HashSet<BlockPos>();
            for (Player player : players) {
                BlockPos center = player.m_20183_();
                boolean tooClose = false;
                ForecastDataStorage.playerData.put(player.m_20148_(), center);
                for (BlockPos existingCenter : centers) {
                    if (existingCenter.m_123333_((Vec3i)center) >= MIN_DISTANCE_BETWEEN_CENTERS) continue;
                    tooClose = true;
                    break;
                }
                if (tooClose) continue;
                centers.add(center);
            }
            for (BlockPos center : centers) {
                ForecastGenerator.generateForecastForRegion(center, level);
            }
            ForecastGenerator.getForecastMap().forEach((key, forecast) -> {
                AtmosphericStateRegistry.initializeState(key, forecast);
                ForecastOrchestrator.generateWindForecast(key, forecast);
            });
            ForecastOrchestrator.initializeDynamicSystems(level);
        }
        finally {
            Runnable r;
            REGENERATING = false;
            while ((r = POST_REGEN_QUEUE.poll()) != null) {
                try {
                    r.run();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void onSwapDay(ServerLevel level) {
        if (ForecastGenerator.getForecastMap().isEmpty()) {
            BlockPos spawn = level.m_220360_();
            ProjectAtmosphere.LOGGER.warn("[Atmosphere] Weekly forecast data missing. Regenerating forecast from spawn...");
            ForecastGenerator.generateForecastForRegion(spawn, level);
            ForecastGenerator.getForecastMap().forEach((key, forecast) -> {
                AtmosphericStateRegistry.initializeState(key, forecast);
                ForecastOrchestrator.generateWindForecast(key, forecast);
            });
            ForecastOrchestrator.initializeDynamicSystems(level);
            return;
        }
        CycloneManager.onMidnight(level);
        AtmosphericStateRegistry.rebuildNeighbors();
    }

    public static void updateForecast(ServerLevel level, BlockPos center) {
        ForecastGenerator.generateForecastForRegion(center, level);
        ForecastGenerator.getForecastMap().forEach((key, forecast) -> {
            AtmosphericStateRegistry.initializeState(key, forecast);
            ForecastOrchestrator.generateWindForecast(key, forecast);
        });
        ForecastOrchestrator.initializeDynamicSystems(level);
    }

    public static float getCurrentTemperature(BiomeInstanceKey key, long tick) {
        return ForecastGenerator.getTemperatureValue(key, tick);
    }

    public static float getCurrentHumidity(BiomeInstanceKey key, long tick) {
        return ForecastGenerator.getHumidityValue(key, tick);
    }

    public static float getCurrentPressure(BiomeInstanceKey key, long tick) {
        return ForecastGenerator.getPressureValue(key, tick);
    }

    public static WindVector getCurrentWind(BiomeInstanceKey key, long tick) {
        return ForecastGenerator.getWindValue(key, tick);
    }

    public static float getCurrentStormChance(BiomeInstanceKey key, long tick) {
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        if (state == null) {
            return 0.0f;
        }
        float rain = Math.min(1.0f, state.getRainIntensity());
        float cloud = state.getCloudCover();
        float wind = Math.min(1.0f, state.getWindStrength() / 18.0f);
        float lowPressure = Math.min(1.0f, Math.max(0.0f, (1013.25f - state.getPressure()) / 55.0f));
        float combined = rain * 0.45f + cloud * 0.3f + wind * 0.15f + lowPressure * 0.1f;
        return Math.max(0.0f, Math.min(1.0f, combined));
    }

    public static void tick(ServerLevel level) {
        GlassDamageManager.tick(level);
        if (sandStormLoaded) {
            SandStormManager.tickSandstormScheduler(level);
        }
        SunlightController.update(level);
        CycloneManager.update(level);
        WindVector.update(level);
        CloudManager.update(level);
        RainSystem.update(level);
        long now = level.m_46467_();
        if (now - lastTornadoCheckTick >= (long)(((Double)AtmoCommonConfig.TORNADO_CHECK_INTERVAL_SEC.get()).floatValue() * 20.0f) && !level.m_6907_().isEmpty()) {
            lastTornadoCheckTick = now;
            if (REGENERATING) {
                ForecastOrchestrator.runAfterRegen(() -> AsyncAtmosphereService.runStorm(() -> TornadoProbabilityManager.onScheduledCheck(level)));
            } else {
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Checking for tornadoes...");
                AsyncAtmosphereService.runStorm(() -> TornadoProbabilityManager.onScheduledCheck(level));
            }
        }
    }

    public static Set<BiomeInstanceKey> getActiveBiomeKeys(ServerLevel level) {
        return activePlayerBiomeKeys.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<BiomeInstanceKey> getActiveBiomeKeysForPlayer(ServerLevel level, ServerPlayer player) {
        UUID uuid = player.m_20148_();
        if (activePlayerBiomeKeys.containsKey(uuid)) {
            return activePlayerBiomeKeys.get(uuid);
        }
        return Collections.emptySet();
    }

    public static void getNearbyBiomeKeys(ServerLevel level, ServerPlayer player, double radius) {
        Vec3 center = Vec3.m_82512_((Vec3i)player.m_20183_());
        double radiusSq = radius * radius;
        Set<BiomeInstanceKey> get = ForecastOrchestrator.getActiveBiomeKeysForPlayer(level, player);
        if (!get.isEmpty()) {
            return;
        }
        get = ForecastGenerator.getForecastMap().keySet().stream().filter(key -> key.samplePos() != null && key.samplePos().m_203198_(center.f_82479_, center.f_82480_, center.f_82481_) <= radiusSq).collect(Collectors.toSet());
        activePlayerBiomeKeys.put(player.m_20148_(), get);
    }

    public static void clearActiveBiomeKeysForPlayer(ServerPlayer player) {
        activePlayerBiomeKeys.remove(player.m_20148_());
    }

    public static void clearActiveBiomeKeys() {
        activePlayerBiomeKeys.clear();
    }

    private static void initializeDynamicSystems(ServerLevel level) {
        AtmosphericStateRegistry.rebuildNeighbors();
        CloudManager.initialize(level);
        CycloneManager.initialize(level);
    }

    public static void generateWindForecast(BiomeInstanceKey key, BiomeForecast forecast) {
        WindVector[] week;
        WindVector today;
        RegionAtmosphereState state = AtmosphericStateRegistry.getState(key);
        WindVector windVector = today = state != null ? state.getWind() : null;
        if (today == null && (week = forecast.getWind()) != null && week.length > 0) {
            today = week[0];
        }
        if (today == null) {
            return;
        }
        float baseMax = today.baseSpeed();
        float gustMax = today.gustSpeed();
        float dirDeg = (float)Math.toDegrees(today.angleRadians());
        float gustProbValue = gustMax > baseMax ? 0.3f : 0.0f;
        EnumMap<WindForecastPart, FloatRange> base = new EnumMap<WindForecastPart, FloatRange>(WindForecastPart.class);
        EnumMap<WindForecastPart, FloatRange> gust = new EnumMap<WindForecastPart, FloatRange>(WindForecastPart.class);
        EnumMap<WindForecastPart, Float> prob = new EnumMap<WindForecastPart, Float>(WindForecastPart.class);
        EnumMap<WindForecastPart, FloatRange> dir = new EnumMap<WindForecastPart, FloatRange>(WindForecastPart.class);
        float[] stageScale = new float[]{0.3f, 1.0f, 0.8f, 0.6f, 0.4f, 0.2f};
        WindForecastPart[] parts = WindForecastPart.values();
        for (int i = 0; i < parts.length; ++i) {
            float scale = stageScale[i];
            base.put(parts[i], new FloatRange(0.0f, baseMax * scale));
            gust.put(parts[i], new FloatRange(0.0f, gustMax * scale));
            prob.put(parts[i], Float.valueOf(gustProbValue));
            dir.put(parts[i], new FloatRange(dirDeg - 15.0f, dirDeg + 15.0f));
        }
        WindEngine.putForecast(key, new WindForecast(base, gust, prob, dir));
    }

    public static HurricaneState getActiveHurricane() {
        List<HurricaneInstance> hurricanes = HurricaneManager.getActiveHurricanes();
        if (hurricanes.isEmpty()) {
            return null;
        }
        HurricaneInstance h = hurricanes.get(0);
        return new HurricaneState(h.position.f_82479_, h.position.f_82481_, h.radius, (double)h.radius * 0.5);
    }
}

