/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import dev.nonamecrackers2.simpleclouds.api.common.cloud.spawning.SpawnInfo;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudSpawningConfig;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.manager.SimpleCloudSpawner;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;

public final class CloudManager {
    private static final Map<BiomeInstanceKey, CloudData> CLOUDS = new ConcurrentHashMap<BiomeInstanceKey, CloudData>();
    private static final int RESPAWN_COOLDOWN_TICKS = 200;
    private static final float HUMIDITY_SPAWN_THRESHOLD = 0.82f;
    private static final float THICKNESS_MIN_HUMIDITY = 0.72f;
    private static final float THICKNESS_MAX_HUMIDITY = 0.95f;
    private static final float THICKNESS_GROWTH_RATE = 3.0E-4f;
    private static final float THICKNESS_BASE_DECAY_RATE = 2.0E-5f;
    private static final float THICKNESS_EXTREME_DECAY_RATE = 1.3E-4f;
    private static final float RAIN_RAMP_HUMIDITY = 0.87f;
    private static final float RAIN_CHANGE_RATE = 0.0025f;
    private static final int DESPAWN_DELAY_TICKS = 1200;
    private static int counter = 0;

    private CloudManager() {
    }

    public static void initialize(ServerLevel level) {
        CLOUDS.clear();
        counter = 0;
    }

    public static void update(ServerLevel level) {
        if (counter++ % 100 != 0) {
            return;
        }
        if (AtmosphericStateRegistry.isEmpty()) {
            return;
        }
        for (RegionAtmosphereState state : AtmosphericStateRegistry.getStates()) {
            BiomeInstanceKey key = state.getKey();
            CloudData data = CLOUDS.get(key);
            float humidity = state.getHumidity();
            if (data == null && humidity >= 0.82f) {
                data = new CloudData();
                CLOUDS.put(key, data);
            }
            if (data == null) {
                state.setCloudCover(Math.max(0.0f, state.getCloudCover() - 0.01f));
                state.setRainIntensity(Math.max(0.0f, state.getRainIntensity() - 0.01f));
                continue;
            }
            data.tickCooldown();
            ++data.ticksAlive;
            data.updateThickness(humidity);
            if (humidity >= 0.82f && !data.spawnedVisual && data.canSpawn() && CloudManager.spawnVisual(level, state)) {
                data.spawnedVisual = true;
                data.ticksAlive = 0L;
            }
            if (data.spawnedVisual) {
                if (humidity < 0.79f) {
                    ++data.dryTicks;
                    if (data.dryTicks >= 1200) {
                        data.spawnedVisual = false;
                        data.resetCooldown();
                    }
                } else {
                    data.dryTicks = 0;
                }
            }
            if (!data.spawnedVisual && data.canSpawn() && data.thickness <= 0.01f && humidity < 0.78f) {
                CLOUDS.remove(key);
                state.setCloudCover(0.0f);
                state.setRainIntensity(0.0f);
                continue;
            }
            if (data.spawnedVisual) {
                data.updateRainIntensity(humidity);
            } else {
                data.rainIntensity = Math.max(0.0f, data.rainIntensity - 0.0025f);
            }
            state.setCloudCover(data.thickness);
            state.setRainIntensity(data.rainIntensity);
        }
    }

    private static boolean spawnVisual(ServerLevel level, RegionAtmosphereState state) {
        WindVector wind;
        String cloudId;
        boolean snowstorm;
        float stormFactor;
        float dewPoint;
        float pressure;
        float humidity;
        if (level == null || state == null) {
            return false;
        }
        if (!SimpleCloudsCompat.getIsInit()) {
            return false;
        }
        CloudGenerator generator = SimpleCloudsCompat.generator;
        if (generator == null) {
            ProjectAtmosphere.LOGGER.warn("[Atmosphere] SimpleClouds generator is null, cannot spawn visual cloud.");
            return false;
        }
        CloudRegion existing = generator.getCloudAtWorldPosition((float)state.getPosition().m_123341_(), (float)state.getPosition().m_123343_());
        if (existing != null) {
            return false;
        }
        float temperature = state.getTemperature();
        int severity = SimpleCloudSpawner.determineCloudSeverity(temperature, humidity = state.getHumidity(), pressure = state.getPressure(), dewPoint = SimpleCloudSpawner.calculateDewPoint(temperature, humidity), stormFactor = ForecastOrchestrator.getCurrentStormChance(state.getKey(), level.m_46468_() % 24000L), level);
        if (severity <= 0) {
            return false;
        }
        boolean freezing = temperature <= 0.0f;
        boolean bl = snowstorm = severity > 5 && freezing;
        if (snowstorm) {
            cloudId = CloudLibrary.getSnowstormCloudId();
        } else {
            cloudId = CloudLibrary.getCloudIdFromSeverity(severity);
            if (CloudLibrary.isThunderCloud(cloudId) && freezing) {
                cloudId = CloudLibrary.getCloudIdFromSeverity(5);
            }
        }
        CloudSpawningConfig config = (CloudSpawningConfig)generator.getSpawnConfig().get();
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"simpleclouds", (String)cloudId);
        CloudSpawningConfig.Info info = config.getWeightInfo(rl);
        if (info == null) {
            ProjectAtmosphere.LOGGER.warn("[Atmosphere] Unknown cloud type: {}", (Object)cloudId);
            return false;
        }
        BiomeInstanceKey key = state.getKey();
        Optional<CloudRegion> dummyOpt = SimpleCloudsCompat.createRegion((SpawnInfo)info, key, level, level.f_46441_, wind = state.getWind() != null ? state.getWind() : WindVector.fromBase(1.0f, 0.0f), generator);
        if (dummyOpt.isEmpty()) {
            return false;
        }
        CloudRegion dummy = dummyOpt.get();
        dummy.setRadius((float)(200 + severity * 50));
        return SimpleCloudsCompat.spawnCloudInBiome(cloudId, key, level, dummy, wind) != null;
    }

    private static final class CloudData {
        private float thickness;
        private long ticksAlive;
        private float rainIntensity;
        private boolean spawnedVisual;
        private int respawnCooldown;
        private int dryTicks = 0;

        private CloudData() {
        }

        private void updateThickness(float humidity) {
            float target = (humidity - 0.72f) / 0.22999996f;
            float delta = (target = Mth.m_14036_((float)target, (float)0.0f, (float)1.0f)) - this.thickness;
            if (Math.abs(delta) < 0.005f) {
                return;
            }
            if (delta > 0.0f) {
                float increase = delta * 0.05f;
                this.thickness = Mth.m_14036_((float)(this.thickness + increase), (float)0.0f, (float)1.0f);
            } else {
                float dryness = Mth.m_14036_((float)((0.82f - humidity) / 0.82f), (float)0.0f, (float)1.0f);
                float decay = 2.0E-5f + dryness * 1.3E-4f;
                this.thickness = Mth.m_14036_((float)(this.thickness - decay), (float)0.0f, (float)1.0f);
            }
        }

        private void updateRainIntensity(float humidity) {
            float desiredRain = 0.0f;
            if (humidity >= 0.87f && this.thickness > 0.4f) {
                float humidityFactor = (humidity - 0.87f) / 0.13f;
                desiredRain = Mth.m_14036_((float)humidityFactor, (float)0.0f, (float)1.0f) * this.thickness;
            }
            this.rainIntensity = desiredRain > this.rainIntensity ? Math.min(desiredRain, this.rainIntensity + 0.0025f) : Math.max(desiredRain, this.rainIntensity - 0.00125f);
        }

        private void tickCooldown() {
            if (this.respawnCooldown > 0) {
                --this.respawnCooldown;
            }
        }

        private void resetCooldown() {
            this.respawnCooldown = 200;
        }

        private boolean canSpawn() {
            return this.respawnCooldown <= 0;
        }
    }
}

