/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;

public final class SunlightController {
    private SunlightController() {
    }

    public static void update(ServerLevel level) {
        if (AtmosphericStateRegistry.isEmpty()) {
            return;
        }
        long dayTime = level.m_46468_();
        float sunAngle = level.m_46490_(1.0f);
        float daylight = SunlightController.baseDaylightCurve(sunAngle);
        float seasonal = SunlightController.seasonalTilt(level);
        for (RegionAtmosphereState state : AtmosphericStateRegistry.getStates()) {
            float cloudCover = state.getCloudCover();
            float rainIntensity = state.getRainIntensity();
            float biomeScale = state.getBiomeSunlightMultiplier();
            float sunlightFactor = daylight * biomeScale * seasonal;
            sunlightFactor *= Math.max(0.0f, 1.0f - cloudCover);
            sunlightFactor = Math.max(0.0f, sunlightFactor);
            state.setSunlight(Math.min(sunlightFactor, 1.0f));
            state.adjustTemperature(sunlightFactor * 6.0f);
            state.adjustHumidity(sunlightFactor * 0.02f);
            state.adjustTemperature(-cloudCover * 6.0f);
            state.adjustHumidity(-rainIntensity * 0.05f);
            state.relaxTowardBase(5.0E-4f);
            state.recordDailySnapshot(dayTime);
        }
    }

    private static float baseDaylightCurve(float sunAngle) {
        float cosine = (float)Math.cos(sunAngle);
        float daylight = Mth.m_14036_((float)cosine, (float)0.0f, (float)1.0f);
        return daylight * daylight;
    }

    private static float seasonalTilt(ServerLevel level) {
        long day = level.m_46468_() / 24000L;
        float seasonProgress = (float)(day % 96L) / 96.0f;
        return 0.85f + 0.15f * Mth.m_14089_((float)(seasonProgress * ((float)Math.PI * 2)));
    }
}

