/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.core;

import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;

public class BiomeForecast {
    private float[][] temperature;
    private float[][] pressure;
    private float[][] humidity;
    private WindVector[] wind;
    private BiomeInstanceKey biomeKey;
    private float[] temperatureDay;
    private float[] temperatureTomorrow;
    private float[] pressureDay;
    private WindVector windDay;
    private float[] pressureTomorrow;
    private float[] humidityDay;
    private float[] humidityTomorrow;
    private WindVector windTomorrow;
    private boolean sandstormExpected;
    private boolean legendaryFlag = false;
    private boolean toughAsNailsFlag = false;

    public BiomeForecast() {
    }

    public BiomeForecast(float[][] temperature, float[][] pressure, float[][] humidity, WindVector[] wind) {
        this.temperature = temperature;
        this.pressure = pressure;
        this.humidity = humidity;
        this.wind = wind;
    }

    public BiomeInstanceKey getBiomeKey() {
        return this.biomeKey;
    }

    public void setBiomeKey(BiomeInstanceKey biomeKey) {
        this.biomeKey = biomeKey;
    }

    public float[][] getTemperature() {
        return this.temperature;
    }

    public float[][] getPressure() {
        return this.pressure;
    }

    public float[][] getHumidity() {
        return this.humidity;
    }

    public WindVector[] getWind() {
        return this.wind;
    }

    public float[] getTemperatureDay() {
        return this.temperatureDay;
    }

    public float[] getTemperatureTomorrow() {
        return this.temperatureTomorrow;
    }

    public float[] getPressureDay() {
        return this.pressureDay;
    }

    public float[] getPressureTomorrow() {
        return this.pressureTomorrow;
    }

    public float[] getHumidityDay() {
        return this.humidityDay;
    }

    public float[] getHumidityTomorrow() {
        return this.humidityTomorrow;
    }

    public void setTemperature(float[][] temperature) {
        this.temperature = temperature;
    }

    public void setPressure(float[][] pressure) {
        this.pressure = pressure;
    }

    public void setHumidity(float[][] humidity) {
        this.humidity = humidity;
    }

    public void setWind(WindVector[] wind) {
        this.wind = wind;
    }

    public void setTemperatureDay(float[] temperatureDay) {
        this.temperatureDay = temperatureDay;
    }

    public void setTemperatureTomorrow(float[] temperatureTomorrow) {
        this.temperatureTomorrow = temperatureTomorrow;
    }

    public void setPressureDay(float[] pressureDay) {
        this.pressureDay = pressureDay;
    }

    public void setPressureTomorrow(float[] pressureTomorrow) {
        this.pressureTomorrow = pressureTomorrow;
    }

    public void setHumidityDay(float[] humidityDay) {
        this.humidityDay = humidityDay;
    }

    public void setHumidityTomorrow(float[] humidityTomorrow) {
        this.humidityTomorrow = humidityTomorrow;
    }

    public void setWindDay(WindVector windDay) {
        this.windDay = windDay;
    }

    public WindVector getWindDay() {
        return this.windDay;
    }

    public void setWindTomorrow(WindVector windTomorrow) {
        this.windTomorrow = windTomorrow;
    }

    public WindVector getWindTomorrow() {
        return this.windTomorrow;
    }

    public boolean hasData(ForecastType type) {
        return switch (type) {
            case ForecastType.HUMIDITY -> {
                if (this.humidityDay != null) {
                    yield true;
                }
                yield false;
            }
            case ForecastType.TEMPERATURE -> {
                if (this.temperatureDay != null) {
                    yield true;
                }
                yield false;
            }
            case ForecastType.PRESSURE -> {
                if (this.pressureDay != null) {
                    yield true;
                }
                yield false;
            }
            case ForecastType.WIND -> {
                if (this.windDay != null && this.wind != null && this.wind.length > 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean isLegendaryFlag() {
        return this.legendaryFlag;
    }

    public void setLegendaryFlag(boolean legendaryFlag) {
        this.legendaryFlag = legendaryFlag;
    }

    public boolean isToughAsNailsFlag() {
        return this.toughAsNailsFlag;
    }

    public void setToughAsNailsFlag(boolean toughAsNailsFlag) {
        this.toughAsNailsFlag = toughAsNailsFlag;
    }

    public void setSandstormExpected(boolean value) {
        this.sandstormExpected = value;
    }

    public boolean isSandstormExpected() {
        return this.sandstormExpected;
    }
}

