/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import java.util.ArrayList;
import java.util.List;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.network.NetworkHandler;
import net.Gabou.projectatmosphere.network.SpawnTornadoPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class TornadoManager {
    private static final List<TornadoInstance> ACTIVE_TORNADOES = new ArrayList<TornadoInstance>();
    private static float shaderTime = 0.0f;

    public static void spawn(Vec3 pos, float radius, WindVector wind, Level level) {
        SpawnRegion temporaryRegion = new SpawnRegion((int)pos.f_82479_, (int)pos.f_82481_, (int)radius);
        for (CloudRegion cloud : CloudManager.get((Level)level).getClouds()) {
            if (!cloud.intersects(temporaryRegion)) continue;
            if (!((Boolean)AtmoCommonConfig.ENABLE_TORNADOES.get()).booleanValue()) {
                return;
            }
            ACTIVE_TORNADOES.add(new TornadoInstance(pos, radius, wind, cloud));
            break;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnClient(Vec3 pos, float radius, WindVector wind) {
        if (!((Boolean)AtmoCommonConfig.ENABLE_TORNADOES.get()).booleanValue()) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        TornadoManager.spawn(pos, radius, wind, (Level)level);
    }

    public static void spawnServer(ServerLevel level, Vec3 pos, float radius, WindVector wind) {
        TornadoManager.spawn(pos, radius, wind, (Level)level);
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SpawnTornadoPacket(pos, radius, wind));
    }

    public static List<TornadoInstance> getActiveTornadoes() {
        return ACTIVE_TORNADOES;
    }

    public static void removeTornado(TornadoInstance tornado) {
        ACTIVE_TORNADOES.remove(tornado);
    }

    public static void clearTornadoes() {
        ACTIVE_TORNADOES.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getShaderTime() {
        return shaderTime;
    }

    public static void tick(Level level) {
        ACTIVE_TORNADOES.removeIf(tornado -> tornado.getLifetimeSeconds() > 600.0f);
        for (TornadoInstance tornado2 : ACTIVE_TORNADOES) {
            float speed = tornado2.wind.baseSpeed() * 0.2f;
            tornado2.position = tornado2.position.m_82520_(Math.cos(tornado2.wind.angleRadians()) * (double)speed, 0.0, Math.sin(tornado2.wind.angleRadians()) * (double)speed);
            tornado2.tick(level);
        }
        if (level.f_46443_) {
            shaderTime += 0.05f;
        }
    }
}

