/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.minecraft.core.BlockPos;

public class WindMath {
    public static float computeGustFactor(long worldTime) {
        float wave = (float)Math.sin((double)(worldTime % 1000L) / 100.0);
        return 0.5f + 0.5f * wave;
    }

    public static float getSmoothGustedSpeed(WindVector vector, long worldTime) {
        float gustFactor = WindMath.computeGustFactor(worldTime);
        return vector.baseSpeed() + (vector.gustSpeed() - vector.baseSpeed()) * gustFactor;
    }

    public static BlockPos getWindOffset(WindVector wind) {
        float angle = wind.angleRadians();
        double dx = Math.cos(angle);
        double dz = Math.sin(angle);
        int offsetX = (int)Math.signum(dx);
        int offsetZ = (int)Math.signum(dz);
        return new BlockPos(offsetX, 0, offsetZ);
    }
}

