/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CloudSpawnScheduler {
    private static final List<ScheduledSpawn> tasks = new ArrayList<ScheduledSpawn>();

    public static void schedule(String cloudId, ServerLevel level, Runnable task, int delayTicks) {
        tasks.add(new ScheduledSpawn(cloudId, level, task, delayTicks));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<ScheduledSpawn> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            ScheduledSpawn s = iterator.next();
            --s.ticksLeft;
            if (s.ticksLeft > 0) continue;
            s.task.run();
            iterator.remove();
        }
    }

    private static class ScheduledSpawn {
        final String cloudId;
        final ServerLevel level;
        final Runnable task;
        int ticksLeft;

        ScheduledSpawn(String cloudId, ServerLevel level, Runnable task, int ticksLeft) {
            this.cloudId = cloudId;
            this.level = level;
            this.task = task;
            this.ticksLeft = ticksLeft;
        }
    }
}

