/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.util;

import java.util.Objects;
import java.util.Random;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.modules.temperature.config.BiomeTempConfig;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;
import sereneseasons.season.SeasonTime;

public class TemperatureGenerator {
    public static final float BOUND_TEMP = 65.0f;
    private static final float IN_MIN = -0.5f;
    private static final float IN_MAX = 2.0f;
    private static final float DEN = 2.5f;
    private static final float SEA_LEVEL = 63.0f;
    private static final float LAPSE_RATE = -0.0065f;

    public static float[][] generateWeekForecast(ServerLevel level, BlockPos chunkPos, ResourceLocation biomeId) {
        ForecastBaseData base = AsyncAtmosphereService.callOnMainThread(() -> {
            int cycleTicks = SeasonHelper.getSeasonState((Level)level).getSeasonCycleTicks();
            long seasonDuration = SeasonHelper.getSeasonState((Level)level).getSeasonDuration();
            long dayDuration = SeasonHelper.getSeasonState((Level)level).getDayDuration();
            SeasonTime st = new SeasonTime(cycleTicks);
            BiomeTempConfig.Season currentSeason = BiomeTempConfig.Season.valueOf(st.getSeason().name());
            float baseTemp = SeasonHooks.getBiomeTemperature((Level)level, (Holder)level.m_204166_(chunkPos), (BlockPos)chunkPos);
            BiomeTempConfig.DailyRange clamp = BiomeTempConfig.getClamp(biomeId, currentSeason);
            return new ForecastBaseData(cycleTicks, seasonDuration, dayDuration, currentSeason, baseTemp, clamp);
        });
        float[][] week = new float[7][2];
        long seed = chunkPos.m_121878_() ^ (long)biomeId.hashCode() ^ ProjectAtmosphere.seed;
        Random rand = new Random(seed);
        float seaLevelC = TemperatureGenerator.toCelsiusSeaLevel(biomeId, base.baseTemp, base.currentSeason);
        float altitudeBase = seaLevelC + ((float)chunkPos.m_123342_() - 63.0f) * -0.0065f;
        float randomAmp = TemperatureGenerator.isTropicalBiome(biomeId, (Level)level, 4.0f, 8.0f);
        float fluctuationAmp = TemperatureGenerator.isTropicalBiome(biomeId, (Level)level, 2.0f, 4.0f);
        for (int day = 0; day < 7; ++day) {
            float prog = (float)((long)base.cycleTicks + (long)day * base.dayDuration) / (float)base.seasonDuration;
            float seasonalShift = (float)Math.sin((double)(prog * 2.0f) * Math.PI) * -10.0f;
            float dailyMean = altitudeBase + seasonalShift;
            float mapNoise = TemperatureGenerator.getDailyFluctuation((Level)level, chunkPos, fluctuationAmp);
            float randNoise = rand.nextFloat() * 2.0f * randomAmp - randomAmp;
            float dailyBase = dailyMean + mapNoise + randNoise;
            float[] sampleTicks = new float[]{21000.0f, 6000.0f, 9000.0f, 12000.0f, 18000.0f};
            float dayMin = Float.POSITIVE_INFINITY;
            float dayMax = Float.NEGATIVE_INFINITY;
            for (float t : sampleTicks) {
                float modifier = TemperatureGenerator.getNighttimeTempModifier(t, biomeId, (Level)level);
                float temp = dailyBase + modifier;
                dayMin = Math.min(dayMin, temp);
                dayMax = Math.max(dayMax, temp);
            }
            if (base.clamp != null) {
                float easedMin = TemperatureGenerator.easeTowardAverage(dayMin, base.clamp.avgNight());
                dayMin = easedMin < base.clamp.minMin() || easedMin > base.clamp.maxMax() ? TemperatureGenerator.ultimateSmoother(easedMin, base.clamp.minMin(), base.clamp.maxMax()) : easedMin;
                float easedMax = TemperatureGenerator.easeTowardAverage(dayMax, base.clamp.avgDay());
                dayMax = easedMax < base.clamp.minMin() || easedMax > base.clamp.maxMax() ? TemperatureGenerator.ultimateSmoother(easedMax, base.clamp.minMin(), base.clamp.maxMax()) : easedMax;
            }
            week[day][0] = dayMin;
            week[day][1] = dayMax;
        }
        return week;
    }

    private static float ultimateSmoother(float v, float boundLow, float boundHigh) {
        float boundMid;
        float credit;
        float sign = Math.signum(v);
        float capped = sign * Math.min(65.0f, Math.abs(v));
        float postCap = capped + (credit = TemperatureGenerator.computeCredit(v) * sign);
        float eased = TemperatureGenerator.easeTowardAverage(postCap, boundMid = (boundLow + boundHigh) / 2.0f);
        if (eased < boundLow) {
            return boundLow + 2.0f;
        }
        if (eased > boundHigh) {
            return boundHigh - 2.0f;
        }
        return eased;
    }

    private static float computeCredit(float value) {
        float abs = Math.abs(value);
        float overshoot = abs - 65.0f;
        if (overshoot <= 0.0f) {
            return 0.0f;
        }
        float credit = (float)(Math.log(overshoot + 1.0f) / Math.log(2.5)) + 0.5f;
        return Math.min(credit * 4.0f, 10.0f);
    }

    private static float easeTowardAverage(float v, float avg) {
        float diff = v - avg;
        float absDiff = Math.abs(diff);
        float strength = (float)(1.0 - Math.exp((double)(-absDiff) / 8.0));
        strength = Math.min(strength, 0.7f);
        return avg + diff * (1.0f - strength);
    }

    private static float toCelsiusSeaLevel(ResourceLocation biome, float baseTemp, BiomeTempConfig.Season season) {
        baseTemp = Math.max(-0.5f, Math.min(2.0f, baseTemp));
        BiomeTempConfig.Range range = BiomeTempConfig.getRange(biome, season);
        float norm = (baseTemp - -0.5f) / 2.5f;
        return range.minC() + norm * (range.maxC() - range.minC());
    }

    private static float getNighttimeTempModifier(float timeOfDay, ResourceLocation biome, Level world) {
        if (timeOfDay >= 12000.0f || timeOfDay < 6000.0f) {
            return TemperatureGenerator.isTropicalBiome(biome, world, -2.0f, -4.0f);
        }
        return TemperatureGenerator.isTropicalBiome(biome, world, 2.0f, 4.0f);
    }

    public static float isTropicalBiome(ResourceLocation biomeId, Level level, float tropicalAmp, float nonTropicalAmp) {
        Registry reg = level.m_9598_().m_175515_(Registries.f_256952_);
        Biome b = (Biome)reg.m_7745_(biomeId);
        if (b == null) {
            return nonTropicalAmp;
        }
        Boolean bol = reg.m_7854_((Object)b).flatMap(arg_0 -> ((Registry)reg).m_203636_(arg_0)).map(holder -> holder.m_203656_(ModTags.Biomes.TROPICAL_BIOMES)).orElse(false);
        return bol != false ? tropicalAmp : nonTropicalAmp;
    }

    private static float getDailyFluctuation(Level world, BlockPos pos, float maxFluctuation) {
        long day = world.m_46468_() / 24000L;
        int hash = Objects.hash(pos.m_123341_() >> 4, pos.m_123343_() >> 4, day);
        return (float)(hash % 200 - 100) / 100.0f * maxFluctuation;
    }

    private record ForecastBaseData(int cycleTicks, long seasonDuration, long dayDuration, BiomeTempConfig.Season currentSeason, float baseTemp, BiomeTempConfig.DailyRange clamp) {
    }
}

