/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public final class TornadoSpawner {
    private TornadoSpawner() {
    }

    public static void spawn(BiomeInstanceKey key, ServerLevel level, float intensity) {
        float radiusSetting = ((Double)AtmoCommonConfig.TORNADO_BASE_SPAWN_RADIUS_M.get()).floatValue();
        BlockPos center = TornadoSpawner.pickSpawnPosNear(key, level, radiusSetting);
        WindVectorApi.WindSample wind = WindVectorApi.getSurface(key);
        float radius = 5.0f + 20.0f * intensity;
        WindVector w = WindVector.fromBase(wind.speedMps(), (float)Math.toRadians(wind.directionDeg()));
        TornadoManager.spawnServer(level, Vec3.m_82512_((Vec3i)center), radius, w);
    }

    private static BlockPos pickSpawnPosNear(BiomeInstanceKey key, ServerLevel level, float radius) {
        BlockPos base = key.samplePos();
        int r = (int)radius;
        int dx = level.f_46441_.m_216339_(-r, r + 1);
        int dz = level.f_46441_.m_216339_(-r, r + 1);
        int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, base.m_123341_() + dx, base.m_123343_() + dz);
        return new BlockPos(base.m_123341_() + dx, y, base.m_123343_() + dz);
    }
}

