/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.wind.FloatRange;
import net.Gabou.projectatmosphere.modules.wind.WindConfig;
import net.Gabou.projectatmosphere.modules.wind.WindForecast;
import net.Gabou.projectatmosphere.modules.wind.WindForecastPart;
import net.Gabou.projectatmosphere.modules.wind.WindGustManager;
import net.Gabou.projectatmosphere.modules.wind.WindRuntimeState;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.server.level.ServerLevel;

public final class WindEngine {
    private static final Map<BiomeInstanceKey, WindForecast> FORECASTS = new HashMap<BiomeInstanceKey, WindForecast>();
    private static final Map<BiomeInstanceKey, WindRuntimeState> STATES = new HashMap<BiomeInstanceKey, WindRuntimeState>();

    private WindEngine() {
    }

    public static void init() {
    }

    public static WindRuntimeState getOrCreateRuntime(BiomeInstanceKey key, ServerLevel level) {
        return STATES.computeIfAbsent(key, k -> new WindRuntimeState());
    }

    public static void tick(ServerLevel level) {
        WindForecastPart part = WindEngine.resolvePart(level);
        long now = level.m_46467_();
        for (Map.Entry<BiomeInstanceKey, WindRuntimeState> entry : STATES.entrySet()) {
            BiomeInstanceKey key = entry.getKey();
            WindRuntimeState state = entry.getValue();
            WindForecast forecast = FORECASTS.get(key);
            if (forecast == null) {
                WindVector.WindSample sample = WindVector.getOrFallback(key);
                WindVector.set(key, sample.speedMps(), sample.directionDeg());
                continue;
            }
            if (state.getNextRetargetTick() <= now) {
                FloatRange dir;
                FloatRange base = forecast.getBaseRanges().get((Object)part);
                if (base != null) {
                    state.setTargetBaseSpeed(base.random(new Random()));
                }
                if ((dir = forecast.getDirRangesDeg().get((Object)part)) != null) {
                    state.setTargetDirectionDeg(dir.random(new Random()));
                }
                state.setNextRetargetTick(now + (long)(WindConfig.baseRetargetSec() * 20.0f));
            }
            float speed = state.getCurrentBaseSpeed() + (state.getTargetBaseSpeed() - state.getCurrentBaseSpeed()) * 0.1f;
            state.setCurrentBaseSpeed(speed);
            float dirCur = state.getCurrentDirectionDeg() + (state.getTargetDirectionDeg() - state.getCurrentDirectionDeg()) * 0.1f;
            state.setCurrentDirectionDeg(dirCur);
            WindGustManager.tick(state, forecast, part, key, level, now);
            float effective = state.getCurrentBaseSpeed() + state.getCurrentGustSpeed();
            WindVector.set(key, effective, state.getCurrentDirectionDeg());
        }
    }

    public static WindForecast getForecast(BiomeInstanceKey key) {
        return FORECASTS.get(key);
    }

    public static void putForecast(BiomeInstanceKey key, WindForecast forecast) {
        FORECASTS.put(key, forecast);
    }

    public static WindForecastPart resolvePart(ServerLevel level) {
        long time = level.m_46468_() % 24000L;
        if (time < 4000L) {
            return WindForecastPart.MORNING;
        }
        if (time < 8000L) {
            return WindForecastPart.NOON;
        }
        if (time < 12000L) {
            return WindForecastPart.AFTERNOON;
        }
        if (time < 16000L) {
            return WindForecastPart.EVENING;
        }
        if (time < 20000L) {
            return WindForecastPart.MIDNIGHT;
        }
        return WindForecastPart.NIGHT;
    }

    public static void syncToClients(BiomeInstanceKey key, ServerLevel level) {
    }
}

