/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import net.Gabou.projectatmosphere.client.BiomeClientTemperatureCache;
import net.Gabou.projectatmosphere.client.HUDOverlayRenderer;
import net.Gabou.projectatmosphere.compat.ColdSweatCompat;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.LegendarySurvivalCompat;
import net.Gabou.projectatmosphere.compat.TemperatureMod;
import net.Gabou.projectatmosphere.compat.ToughAsNailsCompat;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.UnitFormatter;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InstrumentUtils {
    public static void displayWind(Level level, Player player) {
        if (!level.f_46443_) {
            return;
        }
        BlockPos pos = player.m_20183_();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.m_46468_());
        String msg = "Wind: " + UnitFormatter.formatWindSpeed(wind.baseSpeed()) + " at " + String.format("%.0f\u00b0", Math.toDegrees(wind.angleRadians()));
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayTemperature(Level level, Player player) {
        if (!level.f_46443_) {
            return;
        }
        BlockPos pos = player.m_20183_();
        String msg = "Current temperature: " + UnitFormatter.formatTemperature(switch (CompatHandler.getActiveTemperatureMod()) {
            case TemperatureMod.LEGENDARY_SURVIVAL -> LegendarySurvivalCompat.getLiveTemperature(level, pos);
            case TemperatureMod.TOUGH_AS_NAILS -> ToughAsNailsCompat.getLiveTemperatureTAN(level, pos);
            case TemperatureMod.COLD_SWEAT -> ColdSweatCompat.getLiveTemperatureColdSweat(level, pos);
            default -> InstrumentUtils.getForecastTemperature(level, pos);
        });
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    private static float getForecastTemperature(Level level, BlockPos pos) {
        return BiomeClientTemperatureCache.getTemperature(AtmosphereUtils.getBiomeLocation(pos, level), level);
    }

    public static void displayHumidity(Level level, Player player) {
        if (!level.f_46443_) {
            return;
        }
        BlockPos pos = player.m_20183_();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        float humidity = ForecastOrchestrator.getCurrentHumidity(key, level.m_46468_());
        String msg = humidity < 0.01f ? "Humidity: Loading..." : "Current humidity: " + UnitFormatter.formatHumidity(humidity);
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayPressure(Level level, Player player) {
        if (!level.f_46443_) {
            return;
        }
        BlockPos pos = player.m_20183_();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        double pressure = ForecastOrchestrator.getCurrentPressure(key, level.m_46468_());
        String msg = "Current pressure: " + UnitFormatter.formatPressure(pressure);
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayStorm(Level level, Player player) {
        if (!level.f_46443_) {
            return;
        }
        String msg = level.m_46470_() ? "Storm detected!" : (level.m_46471_() ? "Rain detected." : "Skies clear.");
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }
}

