/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.spike.commands;

import java.util.Random;
import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeData;

public class ApplyRandomJoltCommand {
    private final SpikeData data;
    private final float maxJolt;
    private static final Random random = new Random();

    public ApplyRandomJoltCommand(SpikeData data, float maxJolt) {
        this.data = data;
        this.maxJolt = maxJolt;
    }

    public void execute() {
        int day = random.nextInt(7);
        float jolt = this.generateWeightedJolt(this.maxJolt);
        float[] fArray = this.data.week()[day];
        fArray[0] = fArray[0] + jolt;
        float[] fArray2 = this.data.week()[day];
        fArray2[1] = fArray2[1] + jolt;
        this.smoothNeighbors(this.data.week(), day, jolt);
    }

    private float generateWeightedJolt(float max) {
        return (float)(Math.pow(random.nextDouble(), 1.5) * (double)max);
    }

    private void smoothNeighbors(float[][] week, int centerDay, float offset) {
        if (centerDay > 0) {
            float[] fArray = week[centerDay - 1];
            fArray[0] = fArray[0] + offset / 2.0f;
            float[] fArray2 = week[centerDay - 1];
            fArray2[1] = fArray2[1] + offset / 2.0f;
        }
        if (centerDay < 6) {
            float[] fArray = week[centerDay + 1];
            fArray[0] = fArray[0] + offset / 2.0f;
            float[] fArray3 = week[centerDay + 1];
            fArray3[1] = fArray3[1] + offset / 2.0f;
        }
    }
}

