/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.data.TornadoStorageManager;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoProbabilityManager;
import net.Gabou.projectatmosphere.modules.tornado.TornadoSpawner;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projectatmosphere")
public final class TornadoDebug {
    private TornadoDebug() {
    }

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"weatherdebug").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"cloud").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.m_20183_());
            WindVectorApi.WindSample sample = WindVectorApi.getOrFallback(key);
            WindVector wind = WindVector.fromBase(sample.speedMps(), (float)Math.toRadians(sample.directionDeg()));
            String cloudId = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            CloudRegion region = SimpleCloudsCompat.spawnCloudInBiome(cloudId, key, level, null, wind);
            if (region != null) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Spawned cloud '" + cloudId + "' at your position.")), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to spawn cloud '" + cloudId + "'. SimpleClouds may not be initialized yet.")));
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tornado").then(Commands.m_82127_((String)"risk").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.m_20183_());
            float risk = TornadoProbabilityManager.computeRisk(key, level, level.m_46467_());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Risk: " + risk)), false);
            return 1;
        }))).then(Commands.m_82127_((String)"force").then(Commands.m_82129_((String)"intensity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.m_20183_());
            float intensity = FloatArgumentType.getFloat((CommandContext)ctx, (String)"intensity");
            TornadoSpawner.spawn(key, level, intensity);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Tornado spawned."), true);
            return 1;
        })))).then(Commands.m_82127_((String)"cooldown").then(Commands.m_82127_((String)"reset").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.m_20183_());
            TornadoStorageManager.setCooldown(key, 0L);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Cooldown cleared."), true);
            return 1;
        })))));
    }
}

