/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.tools;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class FlowMapGenerator {
    public static void main(String[] args) throws Exception {
        int size = 512;
        BufferedImage img = new BufferedImage(size, size, 1);
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                double u = (double)x / (double)size - 0.5;
                double v = (double)y / (double)size - 0.5;
                double angle = Math.atan2(v, u);
                float fx = (float)(Math.cos(angle) * 0.5 + 0.5);
                float fz = (float)(Math.sin(angle) * 0.5 + 0.5);
                int r = (int)(fx * 255.0f);
                int g = (int)(fz * 255.0f);
                int rgb = r << 16 | g << 8;
                img.setRGB(x, y, rgb);
            }
        }
        ImageIO.write((RenderedImage)img, "PNG", new File("flowmap.png"));
    }
}

