/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.item;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.HorsemanServer;
import io.github.mortuusars.horseman.world.summoning.CallResult;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7430;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperHornItem
extends class_7430 {
    protected final class_6862<class_7444> instruments;

    public CopperHornItem(class_1792.class_1793 properties, class_6862<class_7444> instruments) {
        super(properties, instruments);
        this.instruments = instruments;
    }

    public static class_1799 create(class_1792 item, class_6880<class_7444> instrument) {
        class_1799 itemStack = new class_1799((class_1935)item);
        itemStack.method_57379(class_9334.field_49612, instrument);
        return itemStack;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltip, tooltipFlag);
        if (((Boolean)Config.Client.COPPER_HORN_SHOW_TOOLTIP_DETAILS.get()).booleanValue()) {
            if (class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.horseman.copper_horn.tooltip.bind"));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.horseman.copper_horn.tooltip.summon"));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.horseman.tooltip.hold_shift_for_details"));
            }
        }
    }

    @NotNull
    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 usedHand) {
        if (!player.method_21823() || !(target instanceof class_1496)) {
            return class_1269.field_5811;
        }
        class_1496 horse = (class_1496)target;
        if (!horse.method_5864().method_20210(Horseman.Tags.EntityTypes.SUMMONABLE)) {
            return class_1269.field_5811;
        }
        if (!horse.method_6727()) {
            return class_1269.field_5811;
        }
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_3218 level = (class_3218)class_19372;
        @Nullable Pair<class_5321<class_7444>, class_7444> instrumentData = this.getInstrumentData(stack);
        if (instrumentData == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"gui.horseman.summoning.cannot_bind.no_instrument"), true);
            return class_1269.field_5814;
        }
        class_5321 instrumentKey = (class_5321)instrumentData.getFirst();
        class_7444 instrument = (class_7444)instrumentData.getSecond();
        if (horse.getHorsemanBoundData() != null) {
            if (horse.getHorsemanBoundData().isBoundTo(player)) {
                if (horse.getHorsemanBoundData().instrument().equals((Object)instrumentKey)) {
                    HorsemanServer.getSummoning().bind(level, horse, player, (class_5321<class_7444>)instrumentKey);
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.horseman.summoning.cannot_bind.already_bound_to_you"), true);
                    return class_1269.field_5814;
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"gui.horseman.summoning.cannot_bind.already_bound_to_someone_else"), true);
                return class_1269.field_5814;
            }
        }
        HorsemanServer.getSummoning().bind(level, horse, player, (class_5321<class_7444>)instrumentKey);
        level.method_14199((class_2394)class_2398.field_11224, target.method_23317(), target.method_23318() + 0.75, target.method_23321(), 10, 0.6, 0.6, 0.6, 0.1);
        horse.method_6748();
        level.method_43129(null, (class_1297)horse, class_3417.field_14947, class_3419.field_15254, 1.0f, 1.0f);
        player.method_6019(usedHand);
        this.playInstrument(player.method_37908(), player, instrument, 1.2f);
        this.cooldown(player, instrument);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        return class_1269.field_51370;
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemInHand = player.method_5998(usedHand);
        @Nullable Pair<class_5321<class_7444>, class_7444> instrumentData = this.getInstrumentData(itemInHand);
        if (instrumentData == null) {
            return class_1271.method_22431((Object)itemInHand);
        }
        class_5321 instrumentKey = (class_5321)instrumentData.getFirst();
        class_7444 instrument = (class_7444)instrumentData.getSecond();
        player.method_6019(usedHand);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            CallResult callResult = HorsemanServer.getSummoning().call(serverPlayer, (class_5321<class_7444>)instrumentKey);
            @Nullable class_2561 message = this.getCallResultMessage(callResult);
            if (message != null) {
                player.method_7353(message, true);
            }
            this.playInstrument(level, player, instrument, this.getSoundPitchFromCallResult(callResult));
        }
        this.cooldown(player, instrument);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        return class_1271.method_22428((Object)itemInHand);
    }

    protected void cooldown(class_1657 player, class_7444 instrument) {
        int cooldown = (Integer)Config.Server.COPPER_HORN_COOLDOWN.get();
        if (cooldown < 0) {
            cooldown = instrument.comp_773();
        }
        player.method_7357().method_7906((class_1792)this, cooldown);
    }

    @Nullable
    protected class_2561 getCallResultMessage(CallResult result) {
        if (!((Boolean)Config.Server.COPPER_HORN_ERROR_MESSAGES.get()).booleanValue()) {
            return null;
        }
        return switch (result) {
            default -> throw new MatchException(null, null);
            case CallResult.SUCCESS -> null;
            case CallResult.NO_BOUND_HORSE -> class_2561.method_43471((String)"gui.horseman.summoning.cannot_summon.no_bound_horse");
            case CallResult.HORSE_IS_DEAD -> class_2561.method_43471((String)"gui.horseman.summoning.cannot_summon.dead");
            case CallResult.TOO_FAR -> class_2561.method_43471((String)"gui.horseman.summoning.cannot_summon.too_far");
            case CallResult.INVALID_DIMENSION -> class_2561.method_43471((String)"gui.horseman.summoning.cannot_summon.in_other_dimension");
            case CallResult.NO_SPACE -> class_2561.method_43471((String)"gui.horseman.summoning.cannot_summon.no_space");
            case CallResult.ERROR_HORSE_IS_NOT_BOUND, CallResult.ERROR_ENTITY_NOT_CREATED -> class_2561.method_43471((String)"gui.horseman.summoning.cannot_summon.wrong_or_defective_horse");
        };
    }

    protected float getSoundPitchFromCallResult(CallResult result) {
        return switch (result) {
            default -> throw new MatchException(null, null);
            case CallResult.SUCCESS -> 1.0f;
            case CallResult.HORSE_IS_DEAD -> 0.6f;
            case CallResult.NO_BOUND_HORSE, CallResult.TOO_FAR, CallResult.INVALID_DIMENSION, CallResult.NO_SPACE -> 0.85f;
            case CallResult.ERROR_HORSE_IS_NOT_BOUND, CallResult.ERROR_ENTITY_NOT_CREATED -> 0.9f;
        };
    }

    protected boolean hasInstrument(class_1799 stack) {
        return this.getInstrumentData(stack) != null;
    }

    protected void playInstrument(class_1937 level, class_1657 player, class_7444 instrument, float pitch) {
        class_3414 soundEvent = (class_3414)instrument.comp_772().comp_349();
        float volume = (float)((Integer)Config.Server.COPPER_HORN_SOUND_RANGE.get()).intValue() / 16.0f;
        level.method_43129(null, (class_1297)player, soundEvent, class_3419.field_15247, volume, pitch);
        level.method_32888((class_6880)class_5712.field_39415, player.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
    }

    protected Optional<class_6880<class_7444>> getInstrument(class_1799 stack) {
        @Nullable class_6880 holder = (class_6880)stack.method_57824(class_9334.field_49612);
        if (holder != null) {
            return Optional.of(holder);
        }
        Iterator iterator = class_7923.field_41166.method_40286(this.instruments).iterator();
        return iterator.hasNext() ? Optional.of((class_6880)iterator.next()) : Optional.empty();
    }

    @Nullable
    protected Pair<class_5321<class_7444>, class_7444> getInstrumentData(class_1799 stack) {
        return this.getInstrument(stack).map(holder -> {
            if (holder.method_40230().isEmpty()) {
                return null;
            }
            return Pair.of((Object)((class_5321)holder.method_40230().orElseThrow()), (Object)((class_7444)holder.comp_349()));
        }).orElse(null);
    }
}

