/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.attribute_modifiers;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, priority=950)
public abstract class EntityMixin {
    @Shadow
    public abstract Level level();

    @Shadow
    @Nullable
    public abstract Entity getVehicle();

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addPassenger(Lnet/minecraft/world/entity/Entity;)V")})
    private void startRiding(Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> cir) {
        AttributeInstance instance;
        double breakSpeedModifier;
        Entity entity = (Entity)this;
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (vehicle instanceof AbstractHorse) {
            AttributeInstance instance2;
            AbstractHorse horse = (AbstractHorse)vehicle;
            double stepHeightModifier = (Double)Config.Server.HORSE_STEP_HEIGHT_MODIFIER.get();
            if (stepHeightModifier != 0.0 && (instance2 = horse.getAttribute(Attributes.STEP_HEIGHT)) != null && instance2.getModifier(Horseman.EntityAttributes.MOUNTED_STEP_HEIGHT) == null) {
                instance2.addTransientModifier(new AttributeModifier(Horseman.EntityAttributes.MOUNTED_STEP_HEIGHT, stepHeightModifier, AttributeModifier.Operation.ADD_VALUE));
            }
        }
        if ((breakSpeedModifier = ((Double)Config.Server.MOUNTED_BLOCK_BREAK_SPEED_MODIFIER.get()).doubleValue()) != 0.0 && (instance = player.getAttribute(Attributes.BLOCK_BREAK_SPEED)) != null && instance.getModifier(Horseman.EntityAttributes.MOUNTED_BREAK_SPEED) == null) {
            instance.addTransientModifier(new AttributeModifier(Horseman.EntityAttributes.MOUNTED_BREAK_SPEED, breakSpeedModifier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
    }

    @Inject(method={"removeVehicle()V"}, at={@At(value="HEAD")})
    private void removeVehicle(CallbackInfo ci) {
        AttributeInstance instance;
        AttributeInstance instance2;
        AbstractHorse horse;
        Entity entity = (Entity)this;
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Entity entity2 = this.getVehicle();
        if (entity2 instanceof AbstractHorse && (horse = (AbstractHorse)entity2).getPassengers().size() == 1 && (instance2 = horse.getAttribute(Attributes.STEP_HEIGHT)) != null) {
            instance2.removeModifier(Horseman.EntityAttributes.MOUNTED_STEP_HEIGHT);
        }
        if ((instance = player.getAttribute(Attributes.BLOCK_BREAK_SPEED)) != null) {
            instance.removeModifier(Horseman.EntityAttributes.MOUNTED_BREAK_SPEED);
        }
    }
}

