/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements HitchableHorse {
    @Unique
    protected final Container horseman$leadAccess = AbstractHorseMixin.horseman$createLeadAccess(this.horseman$asHorse());
    @Unique
    protected ItemStack horseman$leadItem = ItemStack.EMPTY;
    @Unique
    protected boolean horseman$isHitched = false;

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public ItemStack horseman$getLead() {
        return this.horseman$leadItem;
    }

    @Override
    public void horseman$setLead(ItemStack stack) {
        this.horseman$leadItem = stack;
    }

    @Override
    public boolean horseman$isHitched() {
        return this.isLeashed() && this.horseman$isHitched;
    }

    @Override
    public void horseman$setHitched(boolean hitched) {
        this.horseman$isHitched = hitched;
    }

    @Override
    public Container horseman$getLeadAccess() {
        return this.horseman$leadAccess;
    }

    @Inject(method={"dropEquipment(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="RETURN")})
    private void onDropEquipment(ServerLevel level, CallbackInfo ci) {
        if (HitchableHorse.hasLead(this)) {
            this.spawnAtLocation(level, HitchableHorse.getLead(this));
            HitchableHorse.setLead(this, ItemStack.EMPTY);
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="RETURN")})
    protected void onAddAdditionalSaveData(ValueOutput output, CallbackInfo ci) {
        ItemStack leadStack = this.horseman$getLead();
        if (!leadStack.isEmpty()) {
            output.store("HorsemanLeadItem", ItemStack.CODEC, (Object)leadStack);
        }
        if (this.horseman$isHitched()) {
            output.putBoolean("HorsemanHitched", true);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="RETURN")})
    protected void onReadAdditionalSaveData(ValueInput input, CallbackInfo ci) {
        this.horseman$leadItem = input.read("HorsemanLeadItem", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.horseman$isHitched = input.getBooleanOr("HorsemanHitched", false);
    }

    @Unique
    private static Container horseman$createLeadAccess(final AbstractHorse horse) {
        return new ContainerSingleItem(){
            private final AbstractHorse ownerHorse;
            {
                this.ownerHorse = horse;
            }

            @NotNull
            public ItemStack getTheItem() {
                return ((HitchableHorse)horse).horseman$getLead();
            }

            public void setTheItem(ItemStack item) {
                ((HitchableHorse)horse).horseman$setLead(item);
            }

            public void setChanged() {
            }

            public boolean stillValid(Player player) {
                return player.getVehicle() == this.ownerHorse || player.canInteractWithEntity((Entity)this.ownerHorse, 4.0);
            }
        };
    }
}

