/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LeashFenceKnotEntity.class})
public abstract class LeashKnotEntityMixin
extends BlockAttachedEntity {
    @Shadow
    public abstract void playPlacementSound();

    protected LeashKnotEntityMixin(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"interact(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        AbstractHorse horse;
        Entity entity = player.getRootVehicle();
        if (entity instanceof AbstractHorse && (horse = (AbstractHorse)entity) instanceof HitchableHorse) {
            HitchableHorse hitchableHorse = (HitchableHorse)horse;
            if (HitchableHorse.isHitched(hitchableHorse)) {
                horse.removeLeash();
                this.playSound(SoundEvents.LEAD_UNTIED);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else if (HitchableHorse.canHitch(hitchableHorse)) {
                horse.setLeashedTo((Entity)player, true);
                HitchableHorse.setHitched(hitchableHorse, true);
                if (!this.level().isClientSide()) {
                    HitchableHorse.syncHorseDataToTrackingClients(hitchableHorse);
                    this.playPlacementSound();
                }
            }
        }
    }
}

