/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Leashable.class})
public interface LeashableMixin {
    @Inject(method={"setLeashedTo(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;Z)V"}, at={@At(value="RETURN")})
    private static <E extends Entity> void setLeashedTo(E entity, Entity leashHolder, boolean broadcastPacket, CallbackInfo ci) {
        if (broadcastPacket && entity instanceof HitchableHorse) {
            HitchableHorse horse = (HitchableHorse)entity;
            if (entity.level() instanceof ServerLevel) {
                HitchableHorse.syncHorseDataToTrackingClients(horse);
            }
        }
    }

    @Inject(method={"dropLeash(Lnet/minecraft/world/entity/Entity;ZZ)V"}, at={@At(value="HEAD")})
    private static <E extends Entity> void onDropLeash(E entity, boolean broadcastPacket, boolean dropItem, CallbackInfo ci, @Share(value="preventDrop") LocalBooleanRef preventDrop) {
        if (!(entity instanceof HitchableHorse)) {
            return;
        }
        HitchableHorse horse = (HitchableHorse)entity;
        boolean hitched = HitchableHorse.isHitched(horse);
        HitchableHorse.setHitched(horse, false);
        if (!entity.level().isClientSide) {
            HitchableHorse.syncHorseDataToTrackingClients(horse);
        }
        preventDrop.set(hitched);
    }

    @WrapWithCondition(method={"dropLeash(Lnet/minecraft/world/entity/Entity;ZZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;spawnAtLocation(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/entity/item/ItemEntity;")})
    private static boolean preventLeadDrop(Entity instance, ServerLevel level, ItemLike item, @Share(value="preventDrop") LocalBooleanRef preventDrop) {
        return !preventDrop.get();
    }
}

