/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"checkAndHandleImportantInteractions(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCheckAndHandleImportantInteractions(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        HitchableHorse horse;
        MobMixin mobMixin = this;
        if (!(mobMixin instanceof HitchableHorse) || !(horse = (HitchableHorse)((Object)mobMixin)).horseman$asHorse().isTamed() || horse.horseman$asHorse().isBaby() || !HitchableHorse.isEnabled()) {
            return;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.getItem() instanceof ShearsItem && !player.isSecondaryUseActive() && HitchableHorse.hasLead(horse)) {
            Level level;
            if (HitchableHorse.isHitched(horse)) {
                horse.horseman$asHorse().removeLeash();
            }
            if ((level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ItemStack leadStack = HitchableHorse.getLead(horse);
                this.spawnAtLocation(serverLevel, leadStack);
            }
            this.level().playSound((Entity)player, (Entity)player, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.8f, 1.0f);
            HitchableHorse.setLead(horse, ItemStack.EMPTY);
            if (!this.level().isClientSide) {
                HitchableHorse.syncHorseDataToTrackingClients(horse);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS_SERVER);
            return;
        }
        if (itemInHand.getItem() instanceof LeadItem && player.isSecondaryUseActive() && HitchableHorse.isHitchable(horse) && !HitchableHorse.hasLead(horse)) {
            ItemStack leadStack = itemInHand.split(1);
            HitchableHorse.setLead(horse, leadStack);
            player.swing(hand);
            cir.setReturnValue((Object)InteractionResult.SUCCESS_SERVER);
            this.level().playSound((Entity)player, (Entity)player, SoundEvents.LEAD_TIED, SoundSource.PLAYERS, 0.8f, 1.0f);
            return;
        }
    }
}

