/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.less_wander;

import io.github.mortuusars.horseman.world.LessWanderingHorse;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onEquipItem(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void onEquipItem(EquipmentSlot slot, ItemStack oldItem, ItemStack newItem, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin;
        if (LessWanderingHorse.isEnabled() && (livingEntityMixin = this) instanceof LessWanderingHorse) {
            LessWanderingHorse lessWanderingHorse = (LessWanderingHorse)((Object)livingEntityMixin);
            if (slot == EquipmentSlot.SADDLE && !newItem.isEmpty()) {
                lessWanderingHorse.horseman$setWanderAnchor(this.position());
            }
        }
    }

    @Inject(method={"stopRiding()V"}, at={@At(value="HEAD")})
    private void onStopRiding(CallbackInfo ci) {
        Entity entity;
        if (LessWanderingHorse.isEnabled() && (entity = this.getVehicle()) instanceof LessWanderingHorse) {
            LessWanderingHorse horse = (LessWanderingHorse)entity;
            horse.horseman$setWanderAnchor(this.getVehicle().position());
        }
    }
}

