/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.momentum;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.world.HorseStepDown;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public abstract float getSpeed();

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getFlyingSpeed()F"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetFlyingSpeed(CallbackInfoReturnable<Float> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof AbstractHorse && ((Boolean)Config.Server.INCREASE_HORSE_AIRBORNE_SPEED.get()).booleanValue() && this.getControllingPassenger() instanceof Player) {
            float delta = ((Double)Config.Server.INCREASE_HORSE_AIRBORNE_SPEED_AMOUNT.get()).floatValue();
            float vanillaSpeed = ((Float)cir.getReturnValue()).floatValue();
            float groundSpeed = this.getSpeed() * 0.216f;
            cir.setReturnValue((Object)Float.valueOf(Mth.lerp((float)delta, (float)vanillaSpeed, (float)groundSpeed)));
        }
    }

    @Inject(method={"travelRidden(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V")})
    private void onTravelRidden(Player player, Vec3 travelVector, CallbackInfo ci) {
        AbstractHorse horse;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof AbstractHorse && HorseStepDown.shouldHorseStepDown(horse = (AbstractHorse)entity)) {
            entity.addDeltaMovement(new Vec3(0.0, -0.65, 0.0));
        }
    }
}

