/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.ride_though_leaves;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.world.LeavesCollisionMode;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BlockBehaviour.class})
public abstract class BlockBehaviourMixin {
    @ModifyReturnValue(method={"getCollisionShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="RETURN")})
    protected VoxelShape getCollisionShape(VoxelShape original, @Local(argsOnly=true) BlockState state, @Local(argsOnly=true) BlockGetter level, @Local(argsOnly=true) BlockPos pos, @Local(argsOnly=true) CollisionContext context) {
        AbstractHorse horse;
        EntityCollisionContext entityContext;
        Entity entity;
        if (!Config.Server.SPEC.isLoaded()) {
            return original;
        }
        LeavesCollisionMode collisionMode = (LeavesCollisionMode)((Object)Config.Server.LEAVES_COLLISION_MODE_WHEN_MOUNTED.get());
        if (collisionMode == LeavesCollisionMode.FULL) {
            return original;
        }
        if (state.getBlock() instanceof LeavesBlock && context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).getEntity()) instanceof AbstractHorse && (horse = (AbstractHorse)entity).getControllingPassenger() instanceof Player) {
            if (collisionMode == LeavesCollisionMode.IGNORE_LOWEST_BLOCK && level.getBlockState(pos.below()).getBlock() instanceof LeavesBlock) {
                return original;
            }
            return Shapes.empty();
        }
        return original;
    }
}

