/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.shears_remove_chest;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.PlatformHelper;
import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractChestedHorse.class})
public abstract class AbstractChestedHorseMixin
extends AbstractHorse
implements HitchableHorse {
    @Shadow
    public abstract boolean hasChest();

    @Shadow
    public abstract int getInventoryColumns();

    @Shadow
    public abstract void setChest(boolean var1);

    protected AbstractChestedHorseMixin(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!((Boolean)Config.Server.HORSE_SHEARS_REMOVE_CHEST.get()).booleanValue() || this.isVehicle() || this.isBaby() || !this.isTamed() || !this.hasChest() || player.isSecondaryUseActive()) {
            return;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        if (PlatformHelper.canShear(itemInHand)) {
            if (this.level().isClientSide) {
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                return;
            }
            int chestInventorySize = 3 * this.getInventoryColumns();
            SimpleContainer dropContainer = new SimpleContainer(chestInventorySize);
            for (int i = 0; i < dropContainer.getContainerSize(); ++i) {
                ItemStack stack = this.inventory.getItem(2 + i);
                dropContainer.setItem(i, stack);
            }
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)dropContainer);
            Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)new ItemStack((ItemLike)Items.CHEST));
            this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.setChest(false);
            this.createInventory();
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

