/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.summoning;

import io.github.mortuusars.horseman.world.item.CopperHornItem;
import io.github.mortuusars.horseman.world.summoning.BoundData;
import io.github.mortuusars.horseman.world.summoning.SummonableHorse;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements SummonableHorse {
    @Unique
    @Nullable
    private BoundData horseman$boundData = null;

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public BoundData getHorsemanBoundData() {
        return this.horseman$boundData;
    }

    @Override
    public void setHorsemanBoundData(@Nullable BoundData data) {
        this.horseman$boundData = data;
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="RETURN")})
    protected void onAddAdditionalSaveData(ValueOutput output, CallbackInfo ci) {
        if (this.horseman$boundData != null) {
            output.store("HorsemanBoundData", BoundData.CODEC, (Object)this.horseman$boundData);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="RETURN")})
    protected void onReadAdditionalSaveData(ValueInput input, CallbackInfo ci) {
        this.horseman$boundData = input.read("HorsemanBoundData", BoundData.CODEC).orElse(null);
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player.isSecondaryUseActive() && player.getItemInHand(hand).getItem() instanceof CopperHornItem) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }
}

