/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.switch_inventory;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.client.SwitchInventory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)Config.Client.INVENTORY_SWITCH_ENABLED.get()).booleanValue()) {
            return;
        }
        if ((AbstractContainerScreen)this instanceof HorseInventoryScreen && Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode) && Screen.hasControlDown()) {
            SwitchInventory.switchFromHorse((AbstractContainerScreen)this);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            cir.setReturnValue((Object)true);
        }
        if (this instanceof InventoryScreen && Minecraft.getInstance().player != null && Minecraft.getInstance().player.jumpableVehicle() instanceof AbstractHorse && Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode) && Screen.hasControlDown()) {
            SwitchInventory.switchFromInventory((AbstractContainerScreen)this);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        ImageButton button;
        if (!((Boolean)Config.Client.INVENTORY_SWITCH_ENABLED.get()).booleanValue()) {
            return;
        }
        if (Minecraft.getInstance().gameMode == null) {
            return;
        }
        if (this instanceof HorseInventoryScreen) {
            if (SwitchInventory.mouseX != null && SwitchInventory.mouseY != null) {
                GLFW.glfwSetCursorPos((long)Minecraft.getInstance().getWindow().getWindow(), (double)SwitchInventory.mouseX, (double)SwitchInventory.mouseY);
                SwitchInventory.mouseX = null;
                SwitchInventory.mouseY = null;
            }
            button = new ImageButton(this.leftPos + (Integer)Config.Client.INVENTORY_SWITCH_HORSE_BUTTON_X.get(), this.topPos + (Integer)Config.Client.INVENTORY_SWITCH_HORSE_BUTTON_Y.get(), 14, 15, SwitchInventory.SWITCH_BUTTON_SPRITES, b -> SwitchInventory.switchFromHorse((AbstractContainerScreen)this));
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.horseman.switch_inventory.button.from_horse.tooltip", (Object[])new Object[]{Component.literal((String)Minecraft.getInstance().options.keyInventory.getTranslatedKeyMessage().getString()).withStyle(ChatFormatting.GRAY)})));
            this.addRenderableWidget((GuiEventListener)button);
        }
        if ((AbstractContainerScreen)this instanceof InventoryScreen && Minecraft.getInstance().gameMode.isServerControlledInventory()) {
            MutableComponent mutableComponent;
            Entity entity;
            button = new ImageButton(this.leftPos + (Integer)Config.Client.INVENTORY_SWITCH_PLAYER_BUTTON_X.get(), this.topPos + (Integer)Config.Client.INVENTORY_SWITCH_PLAYER_BUTTON_Y.get(), 14, 15, SwitchInventory.SWITCH_BUTTON_SPRITES, b -> SwitchInventory.switchFromInventory((AbstractContainerScreen)this));
            if (Minecraft.getInstance().player != null && (entity = Minecraft.getInstance().player.getVehicle()) instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                mutableComponent = entity2.getName();
            } else {
                mutableComponent = Component.translatable((String)"gui.horseman.switch_inventory.button.from_inventory..tooltip.mount");
            }
            MutableComponent vehicleName = mutableComponent;
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.horseman.switch_inventory.button.from_inventory.tooltip", (Object[])new Object[]{vehicleName, Component.literal((String)Minecraft.getInstance().options.keyInventory.getTranslatedKeyMessage().getString()).withStyle(ChatFormatting.GRAY)})));
            this.addRenderableWidget((GuiEventListener)button);
        }
    }
}

