/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.neoforge.mixin.mount_gui;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.mortuusars.horseman.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private long horseman$lastTickVehicleInWater = -1L;

    @Shadow
    protected abstract boolean willPrioritizeJumpInfo();

    @WrapOperation(method={"renderFoodLevel(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;getVehicleMaxHearts(Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int renderFoodLevel_getVehicleMaxHearts(Gui instance, LivingEntity vehicle, Operation<Integer> original) {
        if (!((Boolean)Config.Client.IMPROVED_MOUNT_GUI.get()).booleanValue()) {
            return (Integer)original.call(new Object[]{instance, vehicle});
        }
        return 0;
    }

    @ModifyVariable(method={"nextContextualInfoState()Lnet/minecraft/client/gui/Gui$ContextualInfo;"}, at=@At(value="STORE"), ordinal=1)
    private boolean nextState(boolean willChooseJumpBar) {
        LivingEntity entity;
        PlayerRideableJumping playerRideableJumping;
        if (!((Boolean)Config.Client.IMPROVED_MOUNT_GUI.get()).booleanValue() || this.minecraft.player != null && this.minecraft.player.isCreative()) {
            return willChooseJumpBar;
        }
        if (this.minecraft.player != null && (playerRideableJumping = this.minecraft.player.jumpableVehicle()) instanceof LivingEntity && (entity = (LivingEntity)playerRideableJumping).isInWater()) {
            this.horseman$lastTickVehicleInWater = this.minecraft.player.level().getGameTime();
        }
        return willChooseJumpBar && this.willPrioritizeJumpInfo() && this.minecraft.level != null && this.minecraft.level.getGameTime() - this.horseman$lastTickVehicleInWater > 10L;
    }
}

