/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.item;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.HorsemanServer;
import io.github.mortuusars.horseman.world.summoning.CallResult;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperHornItem
extends InstrumentItem {
    public CopperHornItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltip, TooltipFlag flag) {
        if (((Boolean)Config.Client.COPPER_HORN_SHOW_TOOLTIP_DETAILS.get()).booleanValue()) {
            if (Screen.hasShiftDown()) {
                tooltip.accept((Component)Component.translatable((String)"item.horseman.copper_horn.tooltip.bind"));
                tooltip.accept((Component)Component.translatable((String)"item.horseman.copper_horn.tooltip.summon"));
            } else {
                tooltip.accept((Component)Component.translatable((String)"item.horseman.tooltip.hold_shift_for_details"));
            }
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        if (!player.isSecondaryUseActive() || !(target instanceof AbstractHorse)) {
            return InteractionResult.PASS;
        }
        AbstractHorse horse = (AbstractHorse)target;
        if (!horse.getType().is(Horseman.Tags.EntityTypes.SUMMONABLE)) {
            return InteractionResult.PASS;
        }
        if (!horse.isTamed()) {
            return InteractionResult.PASS;
        }
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel level2 = (ServerLevel)level;
        @Nullable Pair<ResourceKey<Instrument>, Instrument> instrumentData = this.getInstrumentData(stack, (HolderLookup.Provider)player.registryAccess());
        if (instrumentData == null) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.horseman.summoning.cannot_bind.no_instrument"), true);
            return InteractionResult.FAIL;
        }
        ResourceKey instrumentKey = (ResourceKey)instrumentData.getFirst();
        Instrument instrument = (Instrument)instrumentData.getSecond();
        if (horse.getHorsemanBoundData() != null) {
            if (horse.getHorsemanBoundData().isBoundTo(player)) {
                if (horse.getHorsemanBoundData().instrument().equals((Object)instrumentKey)) {
                    HorsemanServer.getSummoning().bind(level2, horse, player, (ResourceKey<Instrument>)instrumentKey);
                    player.displayClientMessage((Component)Component.translatable((String)"gui.horseman.summoning.cannot_bind.already_bound_to_you"), true);
                    return InteractionResult.FAIL;
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.horseman.summoning.cannot_bind.already_bound_to_someone_else"), true);
                return InteractionResult.FAIL;
            }
        }
        HorsemanServer.getSummoning().bind(level2, horse, player, (ResourceKey<Instrument>)instrumentKey);
        level2.sendParticles((ParticleOptions)ParticleTypes.NOTE, target.getX(), target.getY() + 0.75, target.getZ(), 10, 0.6, 0.6, 0.6, 0.1);
        horse.standIfPossible();
        level2.playSound(null, (Entity)horse, SoundEvents.HORSE_AMBIENT, SoundSource.NEUTRAL, 1.0f, 1.0f);
        player.startUsingItem(usedHand);
        this.playInstrument(player.level(), player, instrument, 1.2f);
        this.cooldown(player, stack, instrument);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemInHand = player.getItemInHand(usedHand);
        @Nullable Pair<ResourceKey<Instrument>, Instrument> instrumentData = this.getInstrumentData(itemInHand, (HolderLookup.Provider)player.registryAccess());
        if (instrumentData == null) {
            return InteractionResult.FAIL;
        }
        ResourceKey instrumentKey = (ResourceKey)instrumentData.getFirst();
        Instrument instrument = (Instrument)instrumentData.getSecond();
        player.startUsingItem(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CallResult callResult = HorsemanServer.getSummoning().call(serverPlayer, (ResourceKey<Instrument>)instrumentKey);
            @Nullable Component message = this.getCallResultMessage(callResult);
            if (message != null) {
                player.displayClientMessage(message, true);
            }
            this.playInstrument(level, player, instrument, this.getSoundPitchFromCallResult(callResult));
        }
        this.cooldown(player, itemInHand, instrument);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.CONSUME;
    }

    protected void cooldown(Player player, ItemStack stack, Instrument instrument) {
        int cooldown = (Integer)Config.Server.COPPER_HORN_COOLDOWN.get();
        if (cooldown < 0) {
            cooldown = (int)instrument.useDuration();
        }
        player.getCooldowns().addCooldown(stack, cooldown);
    }

    @Nullable
    protected Component getCallResultMessage(CallResult result) {
        if (!((Boolean)Config.Server.COPPER_HORN_ERROR_MESSAGES.get()).booleanValue()) {
            return null;
        }
        return switch (result) {
            default -> throw new MatchException(null, null);
            case CallResult.SUCCESS -> null;
            case CallResult.NO_BOUND_HORSE -> Component.translatable((String)"gui.horseman.summoning.cannot_summon.no_bound_horse");
            case CallResult.HORSE_IS_DEAD -> Component.translatable((String)"gui.horseman.summoning.cannot_summon.dead");
            case CallResult.TOO_FAR -> Component.translatable((String)"gui.horseman.summoning.cannot_summon.too_far");
            case CallResult.INVALID_DIMENSION -> Component.translatable((String)"gui.horseman.summoning.cannot_summon.in_other_dimension");
            case CallResult.NO_SPACE -> Component.translatable((String)"gui.horseman.summoning.cannot_summon.no_space");
            case CallResult.ERROR_HORSE_IS_NOT_BOUND, CallResult.ERROR_ENTITY_NOT_CREATED -> Component.translatable((String)"gui.horseman.summoning.cannot_summon.wrong_or_defective_horse");
        };
    }

    protected float getSoundPitchFromCallResult(CallResult result) {
        return switch (result) {
            default -> throw new MatchException(null, null);
            case CallResult.SUCCESS -> 1.0f;
            case CallResult.HORSE_IS_DEAD -> 0.6f;
            case CallResult.NO_BOUND_HORSE, CallResult.TOO_FAR, CallResult.INVALID_DIMENSION, CallResult.NO_SPACE -> 0.85f;
            case CallResult.ERROR_HORSE_IS_NOT_BOUND, CallResult.ERROR_ENTITY_NOT_CREATED -> 0.9f;
        };
    }

    protected boolean hasInstrument(ItemStack stack, HolderLookup.Provider registries) {
        return this.getInstrumentData(stack, registries) != null;
    }

    protected void playInstrument(Level level, Player player, Instrument instrument, float pitch) {
        SoundEvent soundEvent = (SoundEvent)instrument.soundEvent().value();
        float volume = (float)((Integer)Config.Server.COPPER_HORN_SOUND_RANGE.get()).intValue() / 16.0f;
        level.playSound(null, (Entity)player, soundEvent, SoundSource.RECORDS, volume, pitch);
        level.gameEvent((Holder)GameEvent.INSTRUMENT_PLAY, player.position(), GameEvent.Context.of((Entity)player));
    }

    protected Optional<Holder<Instrument>> getInstrument(ItemStack stack, HolderLookup.Provider registries) {
        InstrumentComponent instrumentComponent = (InstrumentComponent)stack.get(DataComponents.INSTRUMENT);
        return instrumentComponent != null ? instrumentComponent.unwrap(registries) : Optional.empty();
    }

    @Nullable
    protected Pair<ResourceKey<Instrument>, Instrument> getInstrumentData(ItemStack stack, HolderLookup.Provider registries) {
        return this.getInstrument(stack, registries).map(holder -> {
            if (holder.unwrapKey().isEmpty()) {
                return null;
            }
            return Pair.of((Object)((ResourceKey)holder.unwrapKey().orElseThrow()), (Object)((Instrument)holder.value()));
        }).orElse(null);
    }
}

